"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UX_MESSAGES = exports.TABLE_COLUMN_NAMES = exports.OUTPUT_MESSAGES = exports.FILTER_NAMES = exports.EXECUTE_FILE_LINK_TITLE = exports.ARIA_LABELS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OUTPUT_MESSAGES = Object.freeze({
  hasExpired: command => _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.item.hasExpired', {
    defaultMessage: `{command} failed: action expired`,
    values: {
      command
    }
  }),
  wasSuccessful: command => _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.item.wasSuccessful', {
    defaultMessage: `{command} completed successfully`,
    values: {
      command
    }
  }),
  isPending: command => _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.item.isPending', {
    defaultMessage: `{command} is pending`,
    values: {
      command
    }
  }),
  hasFailed: command => _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.item.hasFailed', {
    defaultMessage: `{command} failed`,
    values: {
      command
    }
  }),
  expandSection: {
    placedAt: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.item.expandSection.placedAt', {
      defaultMessage: 'Command placed'
    }),
    input: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.item.expandSection.input', {
      defaultMessage: 'Input'
    }),
    output: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.item.expandSection.output', {
      defaultMessage: 'Output'
    }),
    startedAt: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.item.expandSection.startedAt', {
      defaultMessage: 'Execution started on'
    }),
    parameters: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.item.expandSection.parameters', {
      defaultMessage: 'Parameters'
    }),
    completedAt: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.item.expandSection.completedAt', {
      defaultMessage: 'Execution completed'
    }),
    comment: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.item.expandSection.comment', {
      defaultMessage: 'Comment'
    })
  }
});
exports.OUTPUT_MESSAGES = OUTPUT_MESSAGES;
const TABLE_COLUMN_NAMES = Object.freeze({
  time: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.time', {
    defaultMessage: 'Time'
  }),
  command: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.command', {
    defaultMessage: 'Command'
  }),
  user: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.user', {
    defaultMessage: 'User'
  }),
  hosts: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.hosts', {
    defaultMessage: 'Hosts'
  }),
  comments: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.comments', {
    defaultMessage: 'Comments'
  }),
  status: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.status', {
    defaultMessage: 'Status'
  }),
  rule: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.rule', {
    defaultMessage: 'Rule'
  })
});
exports.TABLE_COLUMN_NAMES = TABLE_COLUMN_NAMES;
const UX_MESSAGES = Object.freeze({
  flyoutTitle: hostname => _i18n.i18n.translate('xpack.securitySolution.responseActionsList.flyout.title', {
    defaultMessage: `Response actions history : {hostname}`,
    values: {
      hostname
    }
  }),
  pageSubTitle: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.pageSubTitle', {
    defaultMessage: 'View the history of response actions performed on hosts.'
  }),
  fetchError: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.errorMessage', {
    defaultMessage: 'Error while retrieving response actions'
  }),
  filterClearAll: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.filter.clearAll', {
    defaultMessage: 'Clear all'
  }),
  filterSearchPlaceholder: filterName => _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.filter.searchPlaceholder', {
    defaultMessage: 'Search {filterName}',
    values: {
      filterName
    }
  }),
  filterEmptyMessage: filterName => _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.filter.emptyMessage', {
    defaultMessage: 'No {filterName} available',
    values: {
      filterName
    }
  }),
  badge: {
    successful: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.item.badge.successful', {
      defaultMessage: 'Successful'
    }),
    failed: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.item.badge.failed', {
      defaultMessage: 'Failed'
    }),
    pending: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.item.badge.pending', {
      defaultMessage: 'Pending'
    })
  },
  unenrolled: {
    hosts: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.item.hosts.unenrolled.hosts', {
      defaultMessage: 'Hosts unenrolled'
    }),
    host: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.item.hosts.unenrolled.host', {
      defaultMessage: 'Host unenrolled'
    })
  },
  screenReaderExpand: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.screenReader.expand', {
    defaultMessage: 'Expand rows'
  }),
  recordsLabel: totalItemCount => _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.recordRangeLabel', {
    defaultMessage: '{records, plural, one {response action} other {response actions}}',
    values: {
      records: totalItemCount
    }
  }),
  triggeredByRule: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.rule.triggeredByRule', {
    defaultMessage: 'Triggered by rule'
  })
});
exports.UX_MESSAGES = UX_MESSAGES;
const FILTER_NAMES = Object.freeze({
  actions: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.filter.actions', {
    defaultMessage: 'Actions'
  }),
  hosts: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.filter.Hosts', {
    defaultMessage: 'Hosts'
  }),
  statuses: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.filter.statuses', {
    defaultMessage: 'Statuses'
  }),
  users: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.filter.users', {
    defaultMessage: 'Filter by username'
  }),
  automated: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.filter.automated', {
    defaultMessage: 'Automated'
  })
});
exports.FILTER_NAMES = FILTER_NAMES;
const ARIA_LABELS = Object.freeze({
  collapse: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.expandButton.collapse', {
    defaultMessage: 'Collapse'
  }),
  expand: _i18n.i18n.translate('xpack.securitySolution.responseActionsList.list.expandButton.expand', {
    defaultMessage: 'Expand'
  })
});
exports.ARIA_LABELS = ARIA_LABELS;
const EXECUTE_FILE_LINK_TITLE = _i18n.i18n.translate('xpack.securitySolution.responseActionExecuteDownloadLink.downloadButtonLabel', {
  defaultMessage: 'Click here to download full output'
});
exports.EXECUTE_FILE_LINK_TITLE = EXECUTE_FILE_LINK_TITLE;