"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsLogUsersFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _translations = require("../translations");
var _use_action_history_url_params = require("./use_action_history_url_params");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActionsLogUsersFilter = /*#__PURE__*/(0, _react.memo)(({
  isFlyout,
  onChangeUsersFilter,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const {
    users: usersFromUrlParams,
    setUrlUsersFilters
  } = (0, _use_action_history_url_params.useActionHistoryUrlParams)();
  const [searchValue, setSearchValue] = (0, _react.useState)('');
  const onChange = (0, _react.useCallback)(e => {
    setSearchValue(e.target.value);
  }, [setSearchValue]);
  const onSearch = (0, _react.useCallback)(() => {
    const userIds = searchValue.split(',').reduce((acc, curr) => {
      if (curr.trim() !== '') {
        acc.push(curr.trim());
      }
      return acc;
    }, []);
    onChangeUsersFilter(userIds);
    if (!isFlyout) {
      setUrlUsersFilters(userIds.join(','));
    }
  }, [isFlyout, onChangeUsersFilter, searchValue, setUrlUsersFilters]);
  const onClear = (0, _react.useCallback)(() => {
    setSearchValue('');
    onChangeUsersFilter([]);
    if (!isFlyout) {
      setUrlUsersFilters('');
    }
  }, [isFlyout, onChangeUsersFilter, setUrlUsersFilters, setSearchValue]);

  // on load with users in urlParams, set the search value
  (0, _react.useEffect)(() => {
    if (usersFromUrlParams && usersFromUrlParams.length > 0) {
      setSearchValue(usersFromUrlParams.join(','));
    }
    // do this only once on load
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlLayout, {
    clear: {
      onClick: onClear
    },
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": getTestId('users-filter-search'),
    isClearable: true,
    fullWidth: true,
    placeholder: _translations.FILTER_NAMES.users,
    onChange: onChange,
    onSearch: onSearch,
    value: searchValue
  }));
});
exports.ActionsLogUsersFilter = ActionsLogUsersFilter;
ActionsLogUsersFilter.displayName = 'ActionsLogUsersFilter';