"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsLogEmptyState = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _management_empty_state_wrapper = require("../../management_empty_state_wrapper");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyPrompt = (0, _styledComponents.default)(_eui.EuiEmptyPrompt)`
  max-width: 100%;
`;
const ActionsLogEmptyState = /*#__PURE__*/(0, _react.memo)(({
  'data-test-subj': dataTestSubj
}) => {
  const {
    docLinks
  } = (0, _public.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_management_empty_state_wrapper.ManagementEmptyStateWrapper, {
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(EmptyPrompt, {
    iconType: "editorUnorderedList",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.securitySolution.responseActionsHistory.empty.title', {
      defaultMessage: 'Response actions history is empty'
    })),
    body: /*#__PURE__*/_react.default.createElement("div", null, _i18n.i18n.translate('xpack.securitySolution.responseActionsHistory.empty.content', {
      defaultMessage: 'No response actions performed'
    })),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      external: true,
      href: docLinks === null || docLinks === void 0 ? void 0 : docLinks.links.securitySolution.responseActions,
      target: "_blank"
    }, _i18n.i18n.translate('xpack.securitySolution.responseActionsHistory.empty.link', {
      defaultMessage: 'Read more about response actions'
    }))]
  }));
});
exports.ActionsLogEmptyState = ActionsLogEmptyState;
ActionsLogEmptyState.displayName = 'ActionsLogEmptyState';