"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsLogExpandedTray = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _user_privileges = require("../../../../common/components/user_privileges");
var _translations = require("../translations");
var _hooks = require("./hooks");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _response_action_file_download_link = require("../../response_action_file_download_link");
var _endpoint_execute_action = require("../../endpoint_execute_action");
var _empty_value = require("../../../../common/components/empty_value");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const emptyValue = (0, _empty_value.getEmptyValue)();
const customDescriptionListCss = (0, _common.css)`
  &.euiDescriptionList {
    > .euiDescriptionList__title {
      color: ${props => props.theme.eui.euiColorDarkShade};
      font-size: ${props => props.theme.eui.euiFontSizeXS};
    }

    > .euiDescriptionList__title,
    > .euiDescriptionList__description {
      font-weight: ${props => props.theme.eui.euiFontWeightRegular};
      margin-top: ${props => props.theme.eui.euiSizeS};
    }
  }
`;
const topSpacingCss = (0, _common.css)`
  ${props => `${props.theme.eui.euiSize} 0`}
`;
const dashedBorderCss = (0, _common.css)`
  ${props => `1px dashed ${props.theme.eui.euiColorDisabled}`};
`;
const StyledDescriptionListOutput = (0, _common.euiStyled)(_eui.EuiDescriptionList).attrs({
  compressed: true
})`
  ${customDescriptionListCss}
  dd {
    margin: ${topSpacingCss};
    padding: ${topSpacingCss};
    border-top: ${dashedBorderCss};
    border-bottom: ${dashedBorderCss};
  }
`;
const StyledDescriptionList = (0, _common.euiStyled)(_eui.EuiDescriptionList).attrs({
  compressed: true,
  type: 'column'
})`
  ${customDescriptionListCss}
`;
const StyledEuiCodeBlock = (0, _common.euiStyled)(_eui.EuiCodeBlock).attrs({
  transparentBackground: true,
  paddingSize: 'none'
})`
  code {
    color: ${props => props.theme.eui.euiColorDarkShade} !important;
  }
`;
const StyledEuiFlexGroup = (0, _common.euiStyled)(_eui.EuiFlexGroup).attrs({
  direction: 'column',
  className: 'eui-yScrollWithShadows',
  gutterSize: 's'
})`
  max-height: 270px;
  overflow-y: auto;
`;
const OutputContent = /*#__PURE__*/(0, _react.memo)(({
  action,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const {
    canWriteFileOperations,
    canReadActionsLogManagement,
    canAccessEndpointActionsLogManagement
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const {
    command,
    isCompleted,
    isExpired,
    wasSuccessful
  } = action;
  if (isExpired) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations.OUTPUT_MESSAGES.hasExpired(command));
  }
  if (!isCompleted) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations.OUTPUT_MESSAGES.isPending(command));
  }
  if (!wasSuccessful) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations.OUTPUT_MESSAGES.hasFailed(command));
  }
  if (command === 'get-file') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations.OUTPUT_MESSAGES.wasSuccessful(command), /*#__PURE__*/_react.default.createElement(_response_action_file_download_link.ResponseActionFileDownloadLink, {
      action: action,
      canAccessFileDownloadLink: canWriteFileOperations,
      textSize: "xs",
      "data-test-subj": getTestId('getFileDownloadLink')
    }));
  }
  if (command === 'execute') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      "data-test-subj": getTestId('executeDetails')
    }, action.agents.map(agentId => /*#__PURE__*/_react.default.createElement("div", {
      key: agentId
    }, _translations.OUTPUT_MESSAGES.wasSuccessful(command), /*#__PURE__*/_react.default.createElement(_endpoint_execute_action.ExecuteActionHostResponse, {
      action: action,
      agentId: agentId,
      canAccessFileDownloadLink: canAccessEndpointActionsLogManagement || canReadActionsLogManagement,
      textSize: "xs",
      "data-test-subj": getTestId('actionsLogTray')
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations.OUTPUT_MESSAGES.wasSuccessful(command));
});
OutputContent.displayName = 'OutputContent';
const ActionsLogExpandedTray = /*#__PURE__*/(0, _react.memo)(({
  action,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const {
    startedAt,
    completedAt,
    command: _command,
    comment,
    parameters
  } = action;
  const parametersList = (0, _react.useMemo)(() => parameters ? Object.entries(parameters).map(([key, value]) => {
    return `${key}: ${value}`;
  }) : undefined, [parameters]);
  const command = (0, _hooks.getUiCommand)(_command);
  const dataList = (0, _react.useMemo)(() => [{
    title: _translations.OUTPUT_MESSAGES.expandSection.placedAt,
    description: `${startedAt}`
  }, {
    title: _translations.OUTPUT_MESSAGES.expandSection.startedAt,
    description: `${startedAt}`
  }, {
    title: _translations.OUTPUT_MESSAGES.expandSection.completedAt,
    description: `${completedAt !== null && completedAt !== void 0 ? completedAt : emptyValue}`
  }, {
    title: _translations.OUTPUT_MESSAGES.expandSection.input,
    description: `${command}`
  }, {
    title: _translations.OUTPUT_MESSAGES.expandSection.parameters,
    description: parametersList ? parametersList.join(', ') : emptyValue
  }, {
    title: _translations.OUTPUT_MESSAGES.expandSection.comment,
    description: comment ? comment : emptyValue
  }].map(({
    title,
    description
  }) => {
    return {
      title: /*#__PURE__*/_react.default.createElement(StyledEuiCodeBlock, null, title),
      description: /*#__PURE__*/_react.default.createElement(StyledEuiCodeBlock, null, description)
    };
  }), [command, comment, completedAt, parametersList, startedAt]);
  const outputList = (0, _react.useMemo)(() => [{
    title: /*#__PURE__*/_react.default.createElement(StyledEuiCodeBlock, null, `${_translations.OUTPUT_MESSAGES.expandSection.output}:`),
    description:
    /*#__PURE__*/
    // codeblock for output
    _react.default.createElement(StyledEuiCodeBlock, {
      "data-test-subj": getTestId('details-tray-output')
    }, /*#__PURE__*/_react.default.createElement(OutputContent, {
      action: action,
      "data-test-subj": dataTestSubj
    }))
  }], [action, dataTestSubj, getTestId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(StyledEuiFlexGroup, {
    "data-test-subj": getTestId('details-tray')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(StyledDescriptionList, {
    listItems: dataList
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(StyledDescriptionListOutput, {
    listItems: outputList
  }))));
});
exports.ActionsLogExpandedTray = ActionsLogExpandedTray;
ActionsLogExpandedTray.displayName = 'ActionsLogExpandedTray';