"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecuteActionHostResponseOutput = exports.EXECUTE_OUTPUT_FILE_TRUNCATED_MESSAGE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/kibana-react-plugin/common");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
var _empty_value = require("../../../common/components/empty_value");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const emptyValue = (0, _empty_value.getEmptyValue)();
const ACCORDION_BUTTON_TEXT = Object.freeze({
  context: _i18n.i18n.translate('xpack.securitySolution.responseActionExecuteAccordion.executionContext', {
    defaultMessage: 'Execution context'
  }),
  output: {
    regular: _i18n.i18n.translate('xpack.securitySolution.responseActionExecuteAccordion.outputButtonTextRegular', {
      defaultMessage: 'Execution output'
    }),
    truncated: _i18n.i18n.translate('xpack.securitySolution.responseActionExecuteAccordion.outputButtonTextTruncated', {
      defaultMessage: 'Execution output (truncated)'
    })
  },
  error: {
    regular: _i18n.i18n.translate('xpack.securitySolution.responseActionExecuteAccordion.errorButtonTextRegular', {
      defaultMessage: 'Execution error'
    }),
    truncated: _i18n.i18n.translate('xpack.securitySolution.responseActionExecuteAccordion.errorButtonTextTruncated', {
      defaultMessage: 'Execution error (truncated)'
    })
  }
});
const SHELL_INFO = Object.freeze({
  shell: _i18n.i18n.translate('xpack.securitySolution.responseActionExecuteAccordion.shellInformation', {
    defaultMessage: 'Shell'
  }),
  returnCode: _i18n.i18n.translate('xpack.securitySolution.responseActionExecuteAccordion.shellReturnCode', {
    defaultMessage: 'Return code'
  }),
  currentDir: _i18n.i18n.translate('xpack.securitySolution.responseActionExecuteAccordion.currentWorkingDirectory', {
    defaultMessage: 'Executed from'
  })
});
const EXECUTE_OUTPUT_FILE_TRUNCATED_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.responseActionFileDownloadLink.fileTruncated', {
  defaultMessage: 'Output data in the provided zip file is truncated due to file size limitations.'
});
exports.EXECUTE_OUTPUT_FILE_TRUNCATED_MESSAGE = EXECUTE_OUTPUT_FILE_TRUNCATED_MESSAGE;
const StyledEuiText = (0, _common.euiStyled)(_eui.EuiText)`
  white-space: pre-wrap;
  line-break: anywhere;
`;
const ShellInfoContent = /*#__PURE__*/(0, _react.memo)(({
  content,
  textSize,
  title
}) => /*#__PURE__*/_react.default.createElement(StyledEuiText, {
  size: textSize
}, /*#__PURE__*/_react.default.createElement("strong", null, title, ': '), content));
ShellInfoContent.displayName = 'ShellInfoContent';
const ExecutionActionOutputAccordion = /*#__PURE__*/(0, _react.memo)(({
  content = emptyValue,
  initialIsOpen = false,
  isTruncated = false,
  isFileTruncated = false,
  textSize,
  type,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const id = (0, _eui.useGeneratedHtmlId)({
    prefix: 'executeActionOutputAccordions',
    suffix: type
  });
  const accordionButtonContent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: textSize,
    "data-test-subj": getTestId('title')
  }, type !== 'context' ? isTruncated ? ACCORDION_BUTTON_TEXT[type].truncated : ACCORDION_BUTTON_TEXT[type].regular : ACCORDION_BUTTON_TEXT[type]), [getTestId, isTruncated, textSize, type]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: id,
    initialIsOpen: initialIsOpen,
    buttonContent: accordionButtonContent,
    paddingSize: "s",
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(StyledEuiText, {
    size: textSize
  }, isFileTruncated && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "warning",
    "data-test-subj": getTestId('fileTruncatedMsg')
  }, EXECUTE_OUTPUT_FILE_TRUNCATED_MESSAGE), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), typeof content === 'string' ? /*#__PURE__*/_react.default.createElement("p", null, content) : content));
});
ExecutionActionOutputAccordion.displayName = 'ExecutionActionOutputAccordion';
const ExecuteActionHostResponseOutput = /*#__PURE__*/(0, _react.memo)(({
  outputContent,
  'data-test-subj': dataTestSubj,
  textSize = 'xs'
}) => {
  const contextContent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    "data-test-subj": `${dataTestSubj}-shell`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(ShellInfoContent, {
    title: SHELL_INFO.shell,
    content: outputContent.shell,
    textSize: textSize
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(ShellInfoContent, {
    title: SHELL_INFO.returnCode,
    content: outputContent.shell_code,
    textSize: textSize
  }))), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `${dataTestSubj}-cwd`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(ShellInfoContent, {
    title: SHELL_INFO.currentDir,
    content: outputContent.cwd,
    textSize: textSize
  }))), [dataTestSubj, outputContent.cwd, outputContent.shell, outputContent.shell_code, textSize]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(ExecutionActionOutputAccordion, {
    content: contextContent,
    "data-test-subj": `${dataTestSubj}-context`,
    textSize: textSize,
    type: "context"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, outputContent.stderr.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(ExecutionActionOutputAccordion, {
    content: outputContent.stderr.length ? outputContent.stderr : undefined,
    "data-test-subj": `${dataTestSubj}-error`,
    isTruncated: outputContent.stderr_truncated,
    isFileTruncated: outputContent.output_file_stderr_truncated,
    textSize: textSize,
    initialIsOpen: true,
    type: "error"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(ExecutionActionOutputAccordion, {
    content: outputContent.stdout.length ? outputContent.stdout : undefined,
    "data-test-subj": `${dataTestSubj}-output`,
    isTruncated: outputContent.stdout_truncated,
    isFileTruncated: outputContent.output_file_stdout_truncated,
    initialIsOpen: true,
    textSize: textSize,
    type: "output"
  })));
});
exports.ExecuteActionHostResponseOutput = ExecuteActionHostResponseOutput;
ExecuteActionHostResponseOutput.displayName = 'ExecuteActionHostResponseOutput';