"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnknownCommand = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _unsupported_message_callout = require("./unsupported_message_callout");
var _use_data_test_subj = require("../hooks/state_selectors/use_data_test_subj");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _console_code_block = require("./console_code_block");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UnknownCommand = /*#__PURE__*/(0, _react.memo)(({
  command,
  setStatus
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)());
  const message = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.console.unknownCommand.helpMessage",
      defaultMessage: "The text you entered {userInput} is unsupported! Click {helpIcon} {boldHelp} or type {helpCmd} for assistance.",
      values: {
        userInput: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
          bold: true,
          inline: true
        }, command.input),
        helpIcon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "help"
        }),
        helpCmd: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
          bold: true,
          inline: true
        }, 'help'),
        boldHelp: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.console.unknownCommand.helpMessage.help",
          defaultMessage: "Help"
        }))
      }
    }));
  }, [command.input]);
  (0, _react.useEffect)(() => {
    setStatus('success');
  }, [setStatus]);
  return /*#__PURE__*/_react.default.createElement(_unsupported_message_callout.UnsupportedMessageCallout, {
    header: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
      textColor: "danger"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.console.unknownCommand.title",
      defaultMessage: "Unsupported text/command"
    })),
    "data-test-subj": getTestId('unknownCommandError')
  }, message);
});
exports.UnknownCommand = UnknownCommand;
UnknownCommand.displayName = 'UnknownCommand';