"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HistoryItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _common = require("@kbn/kibana-react-plugin/common");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _use_data_test_subj = require("../hooks/state_selectors/use_data_test_subj");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const verticalSpacing = (0, _common.css)`
  ${({
  theme: {
    eui
  }
}) => eui.euiSizeL}
`;
const StyledEuiFlexItemHistoryItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  border-bottom: ${({
  theme: {
    eui
  }
}) => eui.euiBorderWidthThin} dashed
    ${({
  theme: {
    eui
  }
}) => eui.euiBorderColor};
  margin-bottom: ${verticalSpacing};
  padding-bottom: ${verticalSpacing};
`;
const HistoryItem = /*#__PURE__*/(0, _react.memo)(({
  children
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)());
  return /*#__PURE__*/_react.default.createElement(StyledEuiFlexItemHistoryItem, {
    grow: true,
    "data-test-subj": getTestId('historyItem')
  }, children);
});
exports.HistoryItem = HistoryItem;
HistoryItem.displayName = 'HistoryItem';