"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConsoleText = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConsoleText = /*#__PURE__*/(0, _react.memo)(({
  size = 's',
  color,
  children,
  'data-test-subj': dataTestSubj,
  className
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return (
    /*#__PURE__*/
    // className of `font-family-code` below is defined globally in `Console` styles
    _react.default.createElement(_eui.EuiText, {
      size: size,
      "data-test-subj": dataTestSubj,
      className: `font-family-code ${className !== null && className !== void 0 ? className : ''}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: color !== null && color !== void 0 ? color : euiTheme.colors.text
    }, children))
  );
});
exports.ConsoleText = ConsoleText;
ConsoleText.displayName = 'ConsoleText';