"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConsoleFooter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_with_input_visible_state = require("../hooks/state_selectors/use_with_input_visible_state");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _use_data_test_subj = require("../hooks/state_selectors/use_data_test_subj");
var _use_with_footer_content = require("../hooks/state_selectors/use_with_footer_content");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConsoleFooter = /*#__PURE__*/(0, _react.memo)(() => {
  const footerContent = (0, _use_with_footer_content.useWithFooterContent)();
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)());
  const inputVisibleState = (0, _use_with_input_visible_state.useWithInputVisibleState)();
  const textColor = (0, _react.useMemo)(() => {
    return inputVisibleState === 'error' ? 'danger' : 'subdued';
  }, [inputVisibleState]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "none",
    color: "transparent",
    "data-test-subj": getTestId('footer')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: textColor,
    className: "font-style-italic"
  }, footerContent || /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0")));
});
exports.ConsoleFooter = ConsoleFooter;
ConsoleFooter.displayName = 'ConsoleFooter';