"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InputCapture = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
var _use_data_test_subj = require("../../../hooks/state_selectors/use_data_test_subj");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ARIA_PLACEHOLDER_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.inputCapture.ariaPlaceHolder', {
  defaultMessage: 'Enter a command'
});
const deSelectTextOnPage = () => {
  const selection = getSelection();
  if (selection) {
    selection.removeAllRanges();
  }
};
const InputCaptureContainer = _styledComponents.default.div`
  .focus-container {
    // Tried to find a way to not use '!important', but cant seem to figure
    // out right combination of pseudo selectors
    outline: none !important;
  }

  .textSelectionBoundaryHelper {
    opacity: 0;
    position: absolute;
    top: -100vh;
    left: -100vw;
  }

  .invisible-input {
    &,
    &:focus {
      border: none;
      outline: none;
      background-image: none;
      background-color: transparent;
      -webkit-box-shadow: none;
      -moz-box-shadow: none;
      box-shadow: none;
      animation: none !important;
      width: 1ch !important;
      position: absolute;
      opacity: 0;
      top: -100vh;
      left: -100vw;
    }
`;

/**
 * Interface exposed by the `InputCapture` component that allows for interaction
 * with the component's focus/blur states.
 */

/**
 * Component that will capture keyboard and other user input (ex. paste) that
 * occur within this component
 */
const InputCapture = /*#__PURE__*/(0, _react.memo)(({
  onCapture,
  focusRef,
  onChangeFocus,
  children
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)());
  // Reference to the `<div>` that take in focus (`tabIndex`)
  const focusEleRef = (0, _react.useRef)(null);
  const childrenEleRef = (0, _react.useRef)(null);
  const hiddenInputEleRef = (0, _react.useRef)(null);
  const getTextSelection = (0, _react.useCallback)(() => {
    if (focusEleRef.current) {
      var _selection$toString, _focusEleRef$current, _focusEleRef$current2;
      const selection = document.getSelection();

      // Get the selected text and remove any new line breaks from it.
      // The input area does not allow for new line breaks and due to the markup, if user makes
      // a selection that also captures the cursor, then a new line break is included in the selection
      const selectionText = ((_selection$toString = selection === null || selection === void 0 ? void 0 : selection.toString()) !== null && _selection$toString !== void 0 ? _selection$toString : '').replace(/[\r\n]/g, '');
      const isSelectionWithinInputCapture = focusEleRef.current && selection ? ((_focusEleRef$current = focusEleRef.current) === null || _focusEleRef$current === void 0 ? void 0 : _focusEleRef$current.contains(selection.focusNode)) && ((_focusEleRef$current2 = focusEleRef.current) === null || _focusEleRef$current2 === void 0 ? void 0 : _focusEleRef$current2.contains(selection.anchorNode)) : false;
      if (!selection || selectionText.length === 0 || !isSelectionWithinInputCapture) {
        return '';
      }
      return selectionText;
    }
    return '';
  }, []);
  const handleOnKeyDown = (0, _react.useCallback)(ev => {
    // handles the ctrl + a select and allows for clipboard events to be captured via onPaste event handler
    if (ev.metaKey || ev.ctrlKey) {
      if (ev.key === 'a') {
        ev.preventDefault();
        const selection = window.getSelection();
        if (selection && childrenEleRef.current) {
          const range = document.createRange();
          range.selectNodeContents(childrenEleRef.current);
          if (range.toString().length > 0) {
            // clear any current selection
            selection.removeAllRanges();
            // add the input text selection
            selection.addRange(range);
          }
        }
      }
      return;
    }

    // checking to ensure that the key is not a control character. Control character's `.key`
    // are at least two characters long and because we are handling `onKeyDown` we know that
    // a printable `.key` will always be just one character long.
    const newValue = /^[\w\d]{2}/.test(ev.key) ? '' : ev.key;
    const currentTextSelection = getTextSelection();
    const eventDetails = (0, _lodash.pick)(ev, ['key', 'altKey', 'ctrlKey', 'keyCode', 'metaKey', 'repeat', 'shiftKey']);
    onCapture({
      value: newValue,
      selection: currentTextSelection,
      eventDetails
    });
    if (currentTextSelection) {
      deSelectTextOnPage();
    }
  }, [getTextSelection, onCapture]);
  const handleOnPaste = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    ev.stopPropagation();

    // Get the data the user pasted as text and remove all new line breaks from it
    const value = ev.clipboardData.getData('text').replace(/[\r\n]/g, '');
    const currentTextSelection = getTextSelection();

    // hard-coded for use in onCapture and future keyboard functions
    const eventDetails = {
      altKey: false,
      ctrlKey: false,
      key: 'Meta',
      keyCode: 91,
      metaKey: true,
      repeat: false,
      shiftKey: false
    };
    onCapture({
      value,
      selection: currentTextSelection,
      eventDetails
    });
    if (currentTextSelection) {
      deSelectTextOnPage();
    }
  }, [getTextSelection, onCapture]);
  const handleOnFocus = (0, _react.useCallback)(() => {
    if (onChangeFocus) {
      onChangeFocus(true);
    }
  }, [onChangeFocus]);
  const handleOnBlur = (0, _react.useCallback)(() => {
    if (onChangeFocus) {
      onChangeFocus(false);
    }
  }, [onChangeFocus]);
  const focusInterface = (0, _react.useMemo)(() => {
    return {
      focus: (force = false) => {
        var _window$getSelection$, _window$getSelection, _hiddenInputEleRef$cu;
        // If user selected text and `force` is not true, then don't focus (else they lose selection)
        if (!force && ((_window$getSelection$ = (_window$getSelection = window.getSelection()) === null || _window$getSelection === void 0 ? void 0 : _window$getSelection.toString()) !== null && _window$getSelection$ !== void 0 ? _window$getSelection$ : '').length > 0 || document.activeElement === hiddenInputEleRef.current) {
          return;
        }
        (_hiddenInputEleRef$cu = hiddenInputEleRef.current) === null || _hiddenInputEleRef$cu === void 0 ? void 0 : _hiddenInputEleRef$cu.focus();
      },
      blur: () => {
        // only blur if the input has focus
        if (hiddenInputEleRef.current && document.activeElement === hiddenInputEleRef.current) {
          var _hiddenInputEleRef$cu2;
          (_hiddenInputEleRef$cu2 = hiddenInputEleRef.current) === null || _hiddenInputEleRef$cu2 === void 0 ? void 0 : _hiddenInputEleRef$cu2.blur();
        }
      }
    };
  }, []);
  if (focusRef) {
    focusRef.current = focusInterface;
  }
  return /*#__PURE__*/_react.default.createElement(InputCaptureContainer, {
    "data-test-subj": getTestId('inputCapture'),
    onKeyDown: handleOnKeyDown,
    onPaste: handleOnPaste
  }, /*#__PURE__*/_react.default.createElement("div", {
    role: "textbox",
    "aria-placeholder": ARIA_PLACEHOLDER_MESSAGE,
    tabIndex: 0,
    ref: focusEleRef,
    className: "focus-container",
    "data-test-subj": getTestId('keyCapture-input'),
    onBlur: handleOnBlur,
    onFocus: handleOnFocus
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "textSelectionBoundaryHelper"
  }, " "), /*#__PURE__*/_react.default.createElement("div", {
    ref: childrenEleRef,
    className: "text-container"
  }, children), /*#__PURE__*/_react.default.createElement("div", {
    className: "textSelectionBoundaryHelper"
  }, " "), /*#__PURE__*/_react.default.createElement("input", {
    ref: hiddenInputEleRef,
    type: "text",
    value: "",
    tabIndex: -1,
    onPaste: handleOnPaste,
    onChange: () => {},
    spellCheck: "false",
    className: "invisible-input"
  })));
});
exports.InputCapture = InputCapture;
InputCapture.displayName = 'InputCapture';