"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommandExecutionOutput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _moment = _interopRequireDefault(require("moment"));
var _long_running_command_hint = require("./long_running_command_hint");
var _command_execution_result = require("./command_execution_result");
var _user_command_input = require("./user_command_input");
var _use_console_state_dispatch = require("../hooks/state_selectors/use_console_state_dispatch");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CommandOutputContainer = _styledComponents.default.div`
  position: relative;

  .busy-indicator {
    margin-left: 0.5em;
  }
`;
const CommandExecutionOutput = /*#__PURE__*/(0, _react.memo)(({
  item: {
    command,
    state,
    id,
    enteredAt,
    isValid
  }
}) => {
  const dispatch = (0, _use_console_state_dispatch.useConsoleStateDispatch)();
  const RenderComponent = command.commandDefinition.RenderComponent;
  const [isLongRunningCommand, setIsLongRunningCommand] = (0, _react.useState)(false);
  const isRunning = (0, _react.useMemo)(() => {
    return state.status === 'pending';
  }, [state.status]);

  /** Updates the Command's status */
  const setCommandStatus = (0, _react.useCallback)(status => {
    dispatch({
      type: 'updateCommandStatusState',
      payload: {
        id,
        value: status
      }
    });
  }, [dispatch, id]);

  /** Updates the Command's execution store */
  const setCommandStore = (0, _react.useCallback)(updateStoreFn => {
    dispatch({
      type: 'updateCommandStoreState',
      payload: {
        id,
        value: updateStoreFn
      }
    });
  }, [dispatch, id]);

  // keep track if this becomes a long running command
  (0, _react.useEffect)(() => {
    let timeoutId;
    if (isRunning && !isLongRunningCommand) {
      const elapsedSeconds = (0, _moment.default)().diff((0, _moment.default)(enteredAt), 'seconds');
      if (elapsedSeconds >= 15) {
        setIsLongRunningCommand(true);
        return;
      }
      timeoutId = setTimeout(() => {
        setIsLongRunningCommand(true);
      }, (15 - elapsedSeconds) * 1000);
    }
    return () => {
      if (timeoutId) {
        clearTimeout(timeoutId);
      }
    };
  }, [enteredAt, isLongRunningCommand, isRunning]);
  return /*#__PURE__*/_react.default.createElement(CommandOutputContainer, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_user_command_input.UserCommandInput, {
    input: command.inputDisplay,
    isValid: isValid
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "noThemeOverrides"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(RenderComponent, {
    command: command,
    store: state.store,
    status: state.status,
    setStore: setCommandStore,
    setStatus: setCommandStatus,
    ResultComponent: _command_execution_result.CommandExecutionResult
  }), isRunning && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    className: "busy-indicator",
    mono: true
  }), isRunning && isLongRunningCommand && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_long_running_command_hint.LongRunningCommandHint, null))));
});
exports.CommandExecutionOutput = CommandExecutionOutput;
CommandExecutionOutput.displayName = 'CommandExecutionOutput';