"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HelpCommandArgument = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _command_usage = require("../command_usage");
var _help_output = require("../help_output");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Builtin component that handles the output of command's `--help` argument
 */
const HelpCommandArgument = /*#__PURE__*/(0, _react.memo)(props => {
  const CustomCommandHelp = props.command.commandDefinition.HelpComponent;
  (0, _react.useEffect)(() => {
    if (!CustomCommandHelp) {
      props.setStatus('success');
    }
  }, [CustomCommandHelp, props]);
  return CustomCommandHelp ? /*#__PURE__*/_react.default.createElement(CustomCommandHelp, props) : /*#__PURE__*/_react.default.createElement(_help_output.HelpOutput, {
    command: props.command,
    title: _i18n.i18n.translate('xpack.securitySolution.console.buildInCommand.helpArgument.helpTitle', {
      defaultMessage: '{cmdName} command',
      values: {
        cmdName: props.command.args.name
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_command_usage.CommandUsage, {
    commandDef: props.command.commandDefinition,
    errorMessage: props.store.errorMessage
  }));
});
exports.HelpCommandArgument = HelpCommandArgument;
HelpCommandArgument.displayName = 'HelpCommandArgument';