"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.artifactListPageLabels = void 0;
var _i18n = require("@kbn/i18n");
var _artifact_flyout = require("./components/artifact_flyout");
var _artifact_delete_modal = require("./components/artifact_delete_modal");
var _use_with_artifact_delete_item = require("./hooks/use_with_artifact_delete_item");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const artifactListPageLabels = Object.freeze({
  // ------------------------------
  // PAGE labels
  // ------------------------------
  pageTitle: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.pageTitle', {
    defaultMessage: 'Artifact'
  }),
  pageAboutInfo: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.aboutInfo', {
    defaultMessage: 'A list of artifacts for endpoint'
  }),
  pageAddButtonTitle: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.addButtonTitle', {
    defaultMessage: 'Add artifact'
  }),
  // ------------------------------
  // EMPTY state labels
  // ------------------------------
  emptyStateTitleNoEntries: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.emptyStateTitleNoEntries', {
    defaultMessage: 'There are no entries to display.'
  }),
  emptyStateTitle: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.emptyStateTitle', {
    defaultMessage: 'Add your first artifact'
  }),
  emptyStateInfo: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.emptyStateInfo', {
    defaultMessage: 'Add an artifact'
  }),
  emptyStatePrimaryButtonLabel: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.emptyStatePrimaryButtonLabel', {
    defaultMessage: 'Add'
  }),
  // ------------------------------
  // SEARCH BAR labels
  // ------------------------------
  searchPlaceholderInfo: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.searchPlaceholderInfo', {
    defaultMessage: 'Search on the fields below: name, description, comments, value'
  }),
  /**
   * Return the label to show under the search bar with the total number of items that match the current filter (or all)
   * @param total
   *
   * @example:
   *  (total) => i18n.translate('xpack.securitySolution.somepage.showingTotal', {
   *    defaultMessage: 'Showing {total} {total, plural, one {event filter} other {event filters}}',
   *    values: { total },
   *  })
   */
  getShowingCountLabel: total => {
    return _i18n.i18n.translate('xpack.securitySolution.artifactListPage.showingTotal', {
      defaultMessage: 'Showing {total, plural, one {# artifact} other {# artifacts}}',
      values: {
        total
      }
    });
  },
  // ------------------------------
  // CARD ACTIONS labels
  // ------------------------------
  cardActionEditLabel: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.cardActionEditLabel', {
    defaultMessage: 'Edit artifact'
  }),
  cardActionDeleteLabel: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.cardActionDeleteLabel', {
    defaultMessage: 'Delete event filter'
  }),
  // ------------------------------
  // ARTIFACT FLYOUT
  // ------------------------------
  ..._artifact_flyout.ARTIFACT_FLYOUT_LABELS,
  // ------------------------------
  // ARTIFACT DELETE MODAL
  // ------------------------------
  ..._artifact_delete_modal.ARTIFACT_DELETE_LABELS,
  ..._use_with_artifact_delete_item.ARTIFACT_DELETE_ACTION_LABELS
});
exports.artifactListPageLabels = artifactListPageLabels;