"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArtifactFlyout = exports.ARTIFACT_FLYOUT_LABELS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _securitysolutionHookUtils = require("@kbn/securitysolution-hook-utils");
var _use_url_params = require("../../../hooks/use_url_params");
var _use_is_flyout_opened = require("../hooks/use_is_flyout_opened");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _use_set_url_params = require("../hooks/use_set_url_params");
var _management_page_loader = require("../../management_page_loader");
var _kibana = require("../../../../common/lib/kibana");
var _utils = require("../../../../../common/endpoint/service/artifacts/utils");
var _use_with_artifact_submit_data = require("../hooks/use_with_artifact_submit_data");
var _use_is_artifact_allowed_per_policy_usage = require("../hooks/use_is_artifact_allowed_per_policy_usage");
var _artifacts = require("../../../hooks/artifacts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ARTIFACT_FLYOUT_LABELS = Object.freeze({
  flyoutEditTitle: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.flyoutEditTitle', {
    defaultMessage: 'Add artifact'
  }),
  flyoutCreateTitle: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.flyoutCreateTitle', {
    defaultMessage: 'Create artifact'
  }),
  flyoutCancelButtonLabel: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.flyoutCancelButtonLabel', {
    defaultMessage: 'Cancel'
  }),
  flyoutCreateSubmitButtonLabel: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.flyoutCreateSubmitButtonLabel', {
    defaultMessage: 'Add'
  }),
  flyoutEditSubmitButtonLabel: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.flyoutEditSubmitButtonLabel', {
    defaultMessage: 'Save'
  }),
  flyoutDowngradedLicenseTitle: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.expiredLicenseTitle', {
    defaultMessage: 'Expired License'
  }),
  flyoutDowngradedLicenseInfo: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.flyoutDowngradedLicenseInfo', {
    defaultMessage: 'Your Kibana license has been downgraded. Future policy configurations will now be globally assigned to all policies.'
  }),
  /**
   * This should be set to a sentence that includes a link to the documentation page for this specific artifact type.
   *
   * @example
   * // in a component
   * () => {
   *   const { docLinks } = useKibana().services;
   *   return (
   *     <FormattedMessage
   *        id="some-id-1"
   *        defaultMessage="For more information, see our {link}."
   *        value={{
   *          link: <EuiLink target="_blank" href={`${docLinks.links.securitySolution.eventFilters}`}>
   *            <FormattedMessage id="dome-id-2" defaultMessage="Event filters documentation" />
   *          </EuiLink>
   *        }}
   *     />
   *   );
   * }
   */
  flyoutDowngradedLicenseDocsInfo: _ => _i18n.i18n.translate('xpack.securitySolution.artifactListPage.flyoutDowngradedLicenseDocsInfo', {
    defaultMessage: 'For more information, see our documentation.'
  }),
  flyoutEditItemLoadFailure: errorMessage => _i18n.i18n.translate('xpack.securitySolution.artifactListPage.flyoutEditItemLoadFailure', {
    defaultMessage: 'Failed to retrieve item for edit. Reason: {errorMessage}',
    values: {
      errorMessage
    }
  }),
  /**
   * A function returning the label for the success message toast
   * @param itemName
   * @example
   *  ({ name }) => i18n.translate('xpack.securitySolution.some_page.flyoutCreateSubmitSuccess', {
   *    defaultMessage: '"{name}" has been added.',
   *    values: { name },
   *  })
   */
  flyoutCreateSubmitSuccess: ({
    name
  }) => _i18n.i18n.translate('xpack.securitySolution.some_page.flyoutCreateSubmitSuccess', {
    defaultMessage: '"{name}" has been added.',
    values: {
      name
    }
  }),
  /**
   * Returns the edit success message for the toast
   * @param item
   * @example
   *  ({ name }) =>
   *    i18n.translate('xpack.securitySolution.some_page.flyoutEditSubmitSuccess', {
   *    defaultMessage: '"{name}" has been updated.',
   *    values: { name },
   *  })
   */
  flyoutEditSubmitSuccess: ({
    name
  }) => _i18n.i18n.translate('xpack.securitySolution.artifactListPage.flyoutEditSubmitSuccess', {
    defaultMessage: '"{name}" has been updated.',
    values: {
      name
    }
  })
});
exports.ARTIFACT_FLYOUT_LABELS = ARTIFACT_FLYOUT_LABELS;
const createFormInitialState = (listId, item) => {
  return {
    isValid: false,
    item: item !== null && item !== void 0 ? item : (0, _utils.createExceptionListItemForCreate)(listId)
  };
};
/**
 * Show the flyout based on URL params
 */
const ArtifactFlyout = /*#__PURE__*/(0, _react.memo)(({
  apiClient,
  item,
  policies,
  policiesIsLoading,
  FormComponent,
  onSuccess,
  onClose,
  submitHandler,
  labels: _labels = {},
  'data-test-subj': dataTestSubj,
  size = 'm'
}) => {
  var _urlParams$itemId, _formState$item$tags;
  const {
    docLinks: {
      links: {
        securitySolution
      }
    }
  } = (0, _kibana.useKibana)().services;
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const toasts = (0, _kibana.useToasts)();
  const isFlyoutOpened = (0, _use_is_flyout_opened.useIsFlyoutOpened)();
  const setUrlParams = (0, _use_set_url_params.useSetUrlParams)();
  const {
    urlParams
  } = (0, _use_url_params.useUrlParams)();
  const isMounted = (0, _securitysolutionHookUtils.useIsMounted)();
  const labels = (0, _react.useMemo)(() => {
    return {
      ...ARTIFACT_FLYOUT_LABELS,
      ..._labels
    };
  }, [_labels]);
  // TODO:PT Refactor internal/external state into the `useEithArtifactSucmitData()` hook
  const [externalIsSubmittingData, setExternalIsSubmittingData] = (0, _react.useState)(false);
  const [externalSubmitHandlerError, setExternalSubmitHandlerError] = (0, _react.useState)(undefined);
  const isEditFlow = urlParams.show === 'edit';
  const formMode = isEditFlow ? 'edit' : 'create';
  const {
    isLoading: internalIsSubmittingData,
    mutateAsync: submitData,
    error: internalSubmitError
  } = (0, _use_with_artifact_submit_data.useWithArtifactSubmitData)(apiClient, formMode);
  const isSubmittingData = (0, _react.useMemo)(() => {
    return submitHandler ? externalIsSubmittingData : internalIsSubmittingData;
  }, [externalIsSubmittingData, internalIsSubmittingData, submitHandler]);
  const submitError = (0, _react.useMemo)(() => {
    return submitHandler ? externalSubmitHandlerError : internalSubmitError;
  }, [externalSubmitHandlerError, internalSubmitError, submitHandler]);
  const {
    isRefetching: isLoadingItemForEdit,
    error,
    refetch: fetchItemForEdit
  } = (0, _artifacts.useGetArtifact)(apiClient, (_urlParams$itemId = urlParams.itemId) !== null && _urlParams$itemId !== void 0 ? _urlParams$itemId : '', undefined, {
    // We don't want to run this at soon as the component is rendered. `refetch` is called
    // a little later if determined we're in `edit` mode
    enabled: false
  });
  const [formState, setFormState] = (0, _react.useState)(createFormInitialState.bind(null, apiClient.listId, item));
  const showExpiredLicenseBanner = (0, _use_is_artifact_allowed_per_policy_usage.useIsArtifactAllowedPerPolicyUsage)({
    tags: (_formState$item$tags = formState.item.tags) !== null && _formState$item$tags !== void 0 ? _formState$item$tags : []
  }, formMode);
  const hasItemDataForEdit = (0, _react.useMemo)(() => {
    // `item_id` will not be defined for a `create` flow, so we use it below to determine if we
    // are still attempting to load the item for edit from the api
    return !!item || !!formState.item.item_id;
  }, [formState.item.item_id, item]);
  const isInitializing = (0, _react.useMemo)(() => {
    return isEditFlow && !hasItemDataForEdit;
  }, [hasItemDataForEdit, isEditFlow]);
  const handleFlyoutClose = (0, _react.useCallback)(() => {
    if (isSubmittingData) {
      return;
    }

    // `undefined` will cause params to be dropped from url
    setUrlParams({
      ...urlParams,
      itemId: undefined,
      show: undefined
    }, true);
    onClose();
  }, [isSubmittingData, onClose, setUrlParams, urlParams]);
  const handleFormComponentOnChange = (0, _react.useCallback)(({
    item: updatedItem,
    isValid
  }) => {
    if (isMounted()) {
      setFormState({
        item: updatedItem,
        isValid
      });
    }
  }, [isMounted]);
  const handleSuccess = (0, _react.useCallback)(result => {
    toasts.addSuccess(isEditFlow ? labels.flyoutEditSubmitSuccess(result) : labels.flyoutCreateSubmitSuccess(result));
    if (isMounted()) {
      // Close the flyout
      // `undefined` will cause params to be dropped from url
      setUrlParams({
        ...urlParams,
        itemId: undefined,
        show: undefined
      }, true);
      onSuccess();
    }
  }, [isEditFlow, isMounted, labels, onSuccess, setUrlParams, toasts, urlParams]);
  const handleSubmitClick = (0, _react.useCallback)(() => {
    if (submitHandler) {
      setExternalIsSubmittingData(true);
      submitHandler(formState.item, formMode).then(handleSuccess).catch(submitHandlerError => {
        if (isMounted()) {
          setExternalSubmitHandlerError(submitHandlerError);
        }
      }).finally(() => {
        if (isMounted()) {
          setExternalIsSubmittingData(false);
        }
      });
    } else {
      submitData(formState.item).then(handleSuccess);
    }
  }, [formMode, formState.item, handleSuccess, isMounted, submitData, submitHandler]);

  // If we don't have the actual Artifact data yet for edit (in initialization phase - ex. came in with an
  // ID in the url that was not in the list), then retrieve it now
  (0, _react.useEffect)(() => {
    if (isEditFlow && !hasItemDataForEdit && !error && isInitializing && !isLoadingItemForEdit) {
      fetchItemForEdit().then(({
        data: editItemData
      }) => {
        if (editItemData && isMounted()) {
          setFormState(createFormInitialState(apiClient.listId, editItemData));
        }
      });
    }
  }, [apiClient.listId, error, fetchItemForEdit, isEditFlow, isInitializing, isLoadingItemForEdit, hasItemDataForEdit, isMounted]);

  // If we got an error while trying ot retrieve the item for edit, then show a toast message
  (0, _react.useEffect)(() => {
    if (isEditFlow && error) {
      var _error$body;
      toasts.addWarning(labels.flyoutEditItemLoadFailure((error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) || error.message));

      // Blank out the url params for id and show (will close out the flyout)
      setUrlParams({
        itemId: undefined,
        show: undefined
      });
    }
  }, [error, isEditFlow, labels, setUrlParams, toasts, urlParams.itemId]);
  if (!isFlyoutOpened || error) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: size,
    onClose: handleFlyoutClose,
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, isEditFlow ? labels.flyoutEditTitle : labels.flyoutCreateTitle))), !isInitializing && showExpiredLicenseBanner && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: labels.flyoutDowngradedLicenseTitle,
    color: "warning",
    iconType: "help",
    "data-test-subj": getTestId('expiredLicenseCallout')
  }, labels.flyoutDowngradedLicenseInfo, ' ', labels.flyoutDowngradedLicenseDocsInfo(securitySolution)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, isInitializing && /*#__PURE__*/_react.default.createElement(_management_page_loader.ManagementPageLoader, {
    "data-test-subj": getTestId('loader')
  }), !isInitializing && /*#__PURE__*/_react.default.createElement(FormComponent, {
    onChange: handleFormComponentOnChange,
    disabled: isSubmittingData,
    item: formState.item,
    error: submitError !== null && submitError !== void 0 ? submitError : undefined,
    mode: formMode,
    policies: policies,
    policiesIsLoading: policiesIsLoading
  })), !isInitializing && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": getTestId('cancelButton'),
    onClick: handleFlyoutClose,
    disabled: isSubmittingData
  }, labels.flyoutCancelButtonLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": getTestId('submitButton'),
    fill: true,
    disabled: !formState.isValid || isSubmittingData,
    onClick: handleSubmitClick,
    isLoading: isSubmittingData
  }, isEditFlow ? labels.flyoutEditSubmitButtonLabel : labels.flyoutCreateSubmitButtonLabel)))));
});
exports.ArtifactFlyout = ArtifactFlyout;
ArtifactFlyout.displayName = 'ArtifactFlyout';