"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getArtifactListPageUrlPath = exports.extractArtifactListPageUrlSearchParams = void 0;
var _querystring = _interopRequireDefault(require("querystring"));
var _utils = require("./utils");
var _constants = require("../constants");
var _helpers = require("../../../common/components/link_to/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// FIXME: Remove references to `querystring`
// eslint-disable-next-line import/no-nodejs-modules

const SHOW_PARAM_ALLOWED_VALUES = ['edit', 'create'];

/**
 * Normalizes the URL search params by dropping any that are either undefined or whose value is
 * equal to the default value.
 * @param urlSearchParams
 */
const normalizeArtifactListPageUrlSearchParams = (urlSearchParams = {}) => {
  return {
    ...(!(0, _utils.isDefaultOrMissing)(urlSearchParams.page, 1) ? {
      page: urlSearchParams.page
    } : {}),
    ...(!(0, _utils.isDefaultOrMissing)(urlSearchParams.pageSize, _constants.MANAGEMENT_DEFAULT_PAGE_SIZE) ? {
      pageSize: urlSearchParams.pageSize
    } : {}),
    ...(!(0, _utils.isDefaultOrMissing)(urlSearchParams.show, undefined) ? {
      show: urlSearchParams.show
    } : {}),
    ...(!(0, _utils.isDefaultOrMissing)(urlSearchParams.itemId, undefined) ? {
      itemId: urlSearchParams.itemId
    } : {}),
    ...(!(0, _utils.isDefaultOrMissing)(urlSearchParams.filter, '') ? {
      filter: urlSearchParams.filter
    } : ''),
    ...(!(0, _utils.isDefaultOrMissing)(urlSearchParams.includedPolicies, '') ? {
      includedPolicies: urlSearchParams.includedPolicies
    } : '')
  };
};
const extractArtifactListPageUrlSearchParams = query => {
  const showParamValue = (0, _utils.extractFirstParamValue)(query, 'show');
  return {
    page: (0, _utils.extractPageNumber)(query),
    pageSize: (0, _utils.extractPageSizeNumber)(query),
    includedPolicies: (0, _utils.extractFirstParamValue)(query, 'includedPolicies'),
    show: showParamValue && SHOW_PARAM_ALLOWED_VALUES.includes(showParamValue) ? showParamValue : undefined,
    itemId: (0, _utils.extractFirstParamValue)(query, 'itemId')
  };
};
exports.extractArtifactListPageUrlSearchParams = extractArtifactListPageUrlSearchParams;
const getArtifactListPageUrlPath = (path, /** An optional set of url search params. These will be normalized prior to being appended to the url path */
searchParams = {}) => {
  return `${path}${(0, _helpers.appendSearch)(_querystring.default.stringify(normalizeArtifactListPageUrlSearchParams(searchParams)))}`;
};
exports.getArtifactListPageUrlPath = getArtifactListPageUrlPath;