"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLoadPoliciesError = exports.TRUSTED_APPS_TAB = exports.POLICIES_TAB = exports.OS_TITLES = exports.EVENT_FILTERS_TAB = exports.ENDPOINTS_TAB = void 0;
var _i18n = require("@kbn/i18n");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENDPOINTS_TAB = _i18n.i18n.translate('xpack.securitySolution.endpointsTab', {
  defaultMessage: 'Endpoints'
});
exports.ENDPOINTS_TAB = ENDPOINTS_TAB;
const POLICIES_TAB = _i18n.i18n.translate('xpack.securitySolution.policiesTab', {
  defaultMessage: 'Policies'
});
exports.POLICIES_TAB = POLICIES_TAB;
const TRUSTED_APPS_TAB = _i18n.i18n.translate('xpack.securitySolution.trustedAppsTab', {
  defaultMessage: 'Trusted applications'
});
exports.TRUSTED_APPS_TAB = TRUSTED_APPS_TAB;
const EVENT_FILTERS_TAB = _i18n.i18n.translate('xpack.securitySolution.eventFiltersTab', {
  defaultMessage: 'Event filters'
});
exports.EVENT_FILTERS_TAB = EVENT_FILTERS_TAB;
const OS_TITLES = {
  [_securitysolutionUtils.OperatingSystem.WINDOWS]: _i18n.i18n.translate('xpack.securitySolution.administration.os.windows', {
    defaultMessage: 'Windows'
  }),
  [_securitysolutionUtils.OperatingSystem.MAC]: _i18n.i18n.translate('xpack.securitySolution.administration.os.macos', {
    defaultMessage: 'Mac'
  }),
  [_securitysolutionUtils.OperatingSystem.LINUX]: _i18n.i18n.translate('xpack.securitySolution.administration.os.linux', {
    defaultMessage: 'Linux'
  })
};
exports.OS_TITLES = OS_TITLES;
const getLoadPoliciesError = error => {
  return _i18n.i18n.translate('xpack.securitySolution.exceptions.failedLoadPolicies', {
    defaultMessage: 'There was an error loading policies: "{error}"',
    values: {
      error: error.message
    }
  });
};
exports.getLoadPoliciesError = getLoadPoliciesError;