"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExploreLandingPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _types = require("../../app/types");
var _header_page = require("../../common/components/header_page");
var _nav_links = require("../../common/components/navigation/nav_links");
var _page_wrapper = require("../../common/components/page_wrapper");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _landing_links_images = require("../components/landing_links_images");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExploreLandingPage = () => {
  var _useAppRootNavLink$li, _useAppRootNavLink;
  const exploreLinks = (_useAppRootNavLink$li = (_useAppRootNavLink = (0, _nav_links.useAppRootNavLink)(_types.SecurityPageName.exploreLanding)) === null || _useAppRootNavLink === void 0 ? void 0 : _useAppRootNavLink.links) !== null && _useAppRootNavLink$li !== void 0 ? _useAppRootNavLink$li : [];
  return /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, null, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: _translations.EXPLORE_PAGE_TITLE
  }), /*#__PURE__*/_react.default.createElement(_landing_links_images.LandingLinksImages, {
    items: exploreLinks
  }), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.exploreLanding
  }));
};
exports.ExploreLandingPage = ExploreLandingPage;