"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.threatHuntingLandingLinks = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _translations = require("../app/translations");
var _links = require("../explore/links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const threatHuntingLandingLinks = {
  id: _constants.SecurityPageName.exploreLanding,
  title: _translations.EXPLORE,
  path: _constants.EXPLORE_PATH,
  globalNavPosition: 6,
  capabilities: [`${_constants.SERVER_APP_ID}.show`],
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.explore', {
    defaultMessage: 'Explore'
  })],
  links: _links.exploreLinks,
  skipUrlState: true
};
exports.threatHuntingLandingLinks = threatHuntingLandingLinks;