"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LandingLinksImages = exports.LandingImageCards = void 0;
var _eui = require("@elastic/eui");
var _analytics = require("@kbn/analytics");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _links = require("../../common/components/links");
var _nav_item_beta_badge = require("../../common/components/navigation/nav_item_beta_badge");
var _telemetry = require("../../common/lib/telemetry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PrimaryEuiTitle = (0, _styledComponents.default)(_eui.EuiTitle)`
  color: ${props => props.theme.eui.euiColorPrimary};
`;
const LandingLinksDescripton = (0, _styledComponents.default)(_eui.EuiText)`
  padding-top: ${({
  theme
}) => theme.eui.euiSizeXS};
  max-width: 550px;
`;
const Link = _styledComponents.default.a`
  color: inherit;
`;
const StyledFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  align-items: center;
`;
const Content = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  padding-left: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const FlexTitle = _styledComponents.default.div`
  display: flex;
  align-items: center;
`;
const TitleText = _styledComponents.default.h2`
  display: inline;
`;
const SecuritySolutionLink = (0, _links.withSecuritySolutionLink)(Link);
const LandingLinksImages = ({
  items
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column"
}, items.map(({
  title,
  description,
  image,
  id,
  isBeta,
  betaOptions
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  key: id,
  "data-test-subj": "LandingItem"
}, /*#__PURE__*/_react.default.createElement(SecuritySolutionLink, {
  deepLinkId: id,
  tabIndex: -1,
  onClick: () => {
    (0, _telemetry.track)(_analytics.METRIC_TYPE.CLICK, `${_telemetry.TELEMETRY_EVENT.LANDING_CARD}${id}`);
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  hasBorder: true,
  hasShadow: false,
  paddingSize: "m",
  onClick: () => {}
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(StyledFlexItem, {
  grow: false
}, image && /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
  "data-test-subj": "LandingLinksImage",
  size: "l",
  role: "presentation",
  alt: "",
  src: image
})), /*#__PURE__*/_react.default.createElement(Content, null, /*#__PURE__*/_react.default.createElement(PrimaryEuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement(FlexTitle, null, /*#__PURE__*/_react.default.createElement(TitleText, null, title), isBeta && /*#__PURE__*/_react.default.createElement(_nav_item_beta_badge.NavItemBetaBadge, {
  text: betaOptions === null || betaOptions === void 0 ? void 0 : betaOptions.text
}))), /*#__PURE__*/_react.default.createElement(LandingLinksDescripton, {
  size: "s",
  color: "text"
}, description))))))));
exports.LandingLinksImages = LandingLinksImages;
const CARD_WIDTH = 320;
const LandingImageCardItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  max-width: ${CARD_WIDTH}px;
`;
const LandingCardDescription = _styledComponents.default.span`
  font-size: ${({
  theme
}) => theme.eui.euiFontSizeXS};
  padding-top: ${({
  theme
}) => theme.eui.euiSizeXS};
`;

// Needed to use the primary color in the title underlining on hover
const PrimaryTitleCard = (0, _styledComponents.default)(_eui.EuiCard)`
  .euiCard__title {
    color: ${props => props.theme.eui.euiColorPrimary};
  }
`;
const SecuritySolutionCard = (0, _links.withSecuritySolutionLink)(PrimaryTitleCard);
const LandingImageCards = /*#__PURE__*/_react.default.memo(({
  items
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "row",
  wrap: true
}, items.map(({
  id,
  image,
  title,
  description,
  isBeta,
  betaOptions
}) => /*#__PURE__*/_react.default.createElement(LandingImageCardItem, {
  key: id,
  "data-test-subj": "LandingImageCard-item",
  grow: false
}, /*#__PURE__*/_react.default.createElement(SecuritySolutionCard, {
  deepLinkId: id,
  hasBorder: true,
  textAlign: "left",
  paddingSize: "m",
  image: image && /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    "data-test-subj": "LandingImageCard-image",
    role: "presentation",
    size: CARD_WIDTH,
    alt: title,
    src: image
  }),
  title: /*#__PURE__*/_react.default.createElement(PrimaryEuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(FlexTitle, null, /*#__PURE__*/_react.default.createElement(TitleText, null, title), isBeta && /*#__PURE__*/_react.default.createElement(_nav_item_beta_badge.NavItemBetaBadge, {
    text: betaOptions === null || betaOptions === void 0 ? void 0 : betaOptions.text
  }))),
  description: /*#__PURE__*/_react.default.createElement(LandingCardDescription, null, description),
  onClick: () => {
    (0, _telemetry.track)(_analytics.METRIC_TYPE.CLICK, `${_telemetry.TELEMETRY_EVENT.LANDING_CARD}${id}`);
  }
})))));
exports.LandingImageCards = LandingImageCards;
LandingImageCards.displayName = 'LandingImageCards';