"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LandingLinksIcons = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _nav_item_beta_badge = require("../../common/components/navigation/nav_item_beta_badge");
var _links = require("../../common/components/links");
var _telemetry = require("../../common/lib/telemetry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Link = _styledComponents.default.a`
  color: inherit;
`;
const SecuritySolutionLink = (0, _links.withSecuritySolutionLink)(Link);
const Description = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  max-width: 22em;
`;
const StyledEuiTitle = (0, _styledComponents.default)(_eui.EuiTitle)`
  margin-top: ${({
  theme
}) => theme.eui.euiSizeM};
  margin-bottom: ${({
  theme
}) => theme.eui.euiSizeXS};
`;
const LandingLinksIcons = ({
  items
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
  columns: 3,
  gutterSize: "xl"
}, items.map(({
  title,
  description,
  id,
  icon,
  isBeta,
  betaOptions
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  key: id,
  "data-test-subj": "LandingItem"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  alignItems: "flexStart",
  gutterSize: "none",
  responsive: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(SecuritySolutionLink, {
  tabIndex: -1,
  deepLinkId: id
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  "aria-hidden": "true",
  size: "xl",
  type: icon !== null && icon !== void 0 ? icon : '',
  role: "presentation"
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(StyledEuiTitle, {
  size: "xxs"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "none"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkAnchor, {
  deepLinkId: id,
  onClick: () => {
    (0, _telemetry.track)(_telemetry.METRIC_TYPE.CLICK, `${_telemetry.TELEMETRY_EVENT.LANDING_CARD}${id}`);
  }
}, /*#__PURE__*/_react.default.createElement("h2", null, title))), isBeta && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_nav_item_beta_badge.NavItemBetaBadge, {
  text: betaOptions === null || betaOptions === void 0 ? void 0 : betaOptions.text
}))))), /*#__PURE__*/_react.default.createElement(Description, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  color: "text"
}, description))))));
exports.LandingLinksIcons = LandingLinksIcons;