"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOnOpenCloseHandler = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useOnOpenCloseHandler = () => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const handleOnClose = (0, _react.useCallback)(() => {
    setIsOpen(false);
  }, []);
  const handleOnOpen = (0, _react.useCallback)(() => {
    setIsOpen(true);
  }, []);
  return [isOpen, handleOnOpen, handleOnClose];
};
exports.useOnOpenCloseHandler = useOnOpenCloseHandler;