"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyncFlyoutStateWithUrl = void 0;
var _react = require("react");
var _urlState = require("@kbn/url-state");
var _last = _interopRequireDefault(require("lodash/last"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const URL_KEY = 'eventFlyout';
/**
 * Sync flyout state with the url and open it when relevant url state is detected in the query string
 * @returns [ref, flyoutChangesHandler]
 */
const useSyncFlyoutStateWithUrl = () => {
  const flyoutApi = (0, _react.useRef)(null);
  const syncStateToUrl = (0, _urlState.useSyncToUrl)(URL_KEY, data => {
    var _flyoutApi$current;
    (_flyoutApi$current = flyoutApi.current) === null || _flyoutApi$current === void 0 ? void 0 : _flyoutApi$current.openFlyout(data);
  });

  // This should be bound to flyout changed and closed events.
  // When flyout is closed, url state is cleared
  const handleFlyoutChanges = (0, _react.useCallback)(state => {
    if (!state) {
      return syncStateToUrl(undefined);
    }
    return syncStateToUrl({
      ...state,
      preview: (0, _last.default)(state.preview)
    });
  }, [syncStateToUrl]);
  return [flyoutApi, handleFlyoutChanges];
};
exports.useSyncFlyoutStateWithUrl = useSyncFlyoutStateWithUrl;