"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonTab = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _translations = require("./translations");
var _test_ids = require("./test_ids");
var _translations2 = require("../../shared/translations");
var _json_view = require("../../../common/components/event_details/json_view");
var _context = require("../context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Json view displayed in the document details expandable flyout right section
 */
const JsonTab = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    searchHit
  } = (0, _context.useRightPanelContext)();
  if (!searchHit) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "error",
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", null, (0, _translations2.ERROR_TITLE)(_translations.DOCUMENT_ERROR_TITLE)),
      body: /*#__PURE__*/_react.default.createElement("p", null, (0, _translations2.ERROR_MESSAGE)(_translations.DOCUMENT_ERROR_DETAILS)),
      "data-test-subj": _test_ids.JSON_TAB_ERROR_TEST_ID
    });
  }
  return /*#__PURE__*/_react.default.createElement(_json_view.JsonView, {
    rawEventData: searchHit
  });
});
exports.JsonTab = JsonTab;
JsonTab.displayName = 'JsonTab';