"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchThreatIntelligence = void 0;
var _react = require("react");
var _lodash = require("lodash");
var _helpers = require("../../../timelines/components/side_panel/event_details/helpers");
var _helpers2 = require("../../../common/components/event_details/cti_details/helpers");
var _event_enrichment = require("../../../common/containers/cti/event_enrichment");
var _constants = require("../../../../common/cti/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to retrieve threat intelligence data for the expandable flyout right and left sections.
 */
const useFetchThreatIntelligence = ({
  dataFormattedForFieldBrowser
}) => {
  const {
    isAlert
  } = (0, _helpers.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);

  // retrieve the threat enrichment fields with value for the current document
  // (see https://github.com/elastic/kibana/blob/main/x-pack/plugins/security_solution/common/cti/constants.ts#L35)
  const eventFields = (0, _react.useMemo)(() => (0, _helpers2.getEnrichmentFields)(dataFormattedForFieldBrowser || []), [dataFormattedForFieldBrowser]);

  // retrieve existing enrichment fields and their value
  const existingEnrichments = (0, _react.useMemo)(() => isAlert ? (0, _helpers2.parseExistingEnrichments)(dataFormattedForFieldBrowser || []).map(enrichmentData => (0, _helpers2.timelineDataToEnrichment)(enrichmentData)) : [], [dataFormattedForFieldBrowser, isAlert]);

  // api call to retrieve all documents that match the eventFields
  const {
    result: response,
    loading
  } = (0, _event_enrichment.useInvestigationTimeEnrichment)(eventFields);

  // combine existing enrichment and enrichment from the api response
  // also removes the investigation-time enrichments if the exact indicator already exists
  const allEnrichments = (0, _react.useMemo)(() => {
    if (loading || !(response !== null && response !== void 0 && response.enrichments)) {
      return existingEnrichments;
    }
    return (0, _helpers2.filterDuplicateEnrichments)([...existingEnrichments, ...response.enrichments]);
  }, [loading, response, existingEnrichments]);

  // separate threat matches (from indicator-match rule) from threat enrichments (realtime query)
  const {
    [_constants.ENRICHMENT_TYPES.IndicatorMatchRule]: threatMatches,
    [_constants.ENRICHMENT_TYPES.InvestigationTime]: threatEnrichments
  } = (0, _lodash.groupBy)(allEnrichments, 'matched.type');
  return {
    loading,
    error: !dataFormattedForFieldBrowser,
    threatMatches,
    threatMatchesCount: (threatMatches || []).length,
    threatEnrichments,
    threatEnrichmentsCount: (threatEnrichments || []).length
  };
};
exports.useFetchThreatIntelligence = useFetchThreatIntelligence;