"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizationsSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _expandable_section = require("./expandable_section");
var _test_ids = require("./test_ids");
var _translations = require("./translations");
var _analyzer_preview = require("./analyzer_preview");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Visualizations section in overview. It contains analyzer preview and session view preview.
 */
const VisualizationsSection = ({
  expanded = false
}) => {
  return /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    expanded: expanded,
    title: _translations.VISUALIZATIONS_TITLE,
    "data-test-subj": _test_ids.VISUALIZATIONS_SECTION_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_analyzer_preview.AnalyzerPreview, null));
};
exports.VisualizationsSection = VisualizationsSection;
VisualizationsSection.displayName = 'VisualizationsSection';