"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserEntityOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _search_strategy = require("../../../../common/search_strategy");
var _field_renderers = require("../../../timelines/components/field_renderers/field_renderers");
var _links = require("../../../common/components/links");
var _page = require("../../../common/components/page");
var _overview_description_list = require("../../../common/components/overview_description_list");
var _common = require("../../../explore/components/risk_score/severity/common");
var _empty_value = require("../../../common/components/empty_value");
var _sourcerer = require("../../../common/containers/sourcerer");
var _use_global_time = require("../../../common/containers/use_global_time");
var _risk_score = require("../../../explore/containers/risk_score");
var i18n = _interopRequireWildcard(require("../../../overview/components/user_overview/translations"));
var _translations2 = require("./translations");
var _test_ids = require("./test_ids");
var _observed_details = require("../../../explore/users/containers/users/observed_details");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiBetaBadge = (0, _styledComponents.default)(_eui.EuiBetaBadge)`
  margin-left: ${({
  theme
}) => theme.eui.euiSizeXS};
`;
const CONTEXT_ID = `flyout-user-entity-overview`;
/**
 * User preview content for the entities preview in right flyout. It contains ip addresses and risk classification
 */
const UserEntityOverview = ({
  userName
}) => {
  const {
    from,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const {
    selectedPatterns
  } = (0, _sourcerer.useSourcererDataView)();
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const filterQuery = (0, _react.useMemo)(() => userName ? (0, _search_strategy.buildUserNamesFilter)([userName]) : undefined, [userName]);
  const [_, {
    userDetails: data
  }] = (0, _observed_details.useObservedUserDetails)({
    endDate: to,
    userName,
    indexNames: selectedPatterns,
    startDate: from
  });
  const {
    data: userRisk,
    isLicenseValid
  } = (0, _risk_score.useRiskScore)({
    filterQuery,
    riskEntity: _search_strategy.RiskScoreEntity.user,
    timerange
  });
  const descriptionList = (0, _react.useMemo)(() => [{
    title: i18n.HOST_IP,
    description: /*#__PURE__*/_react.default.createElement(_field_renderers.DefaultFieldRenderer, {
      rowItems: (0, _fp.getOr)([], 'host.ip', data),
      attrName: 'host.ip',
      idPrefix: CONTEXT_ID,
      isDraggable: false,
      render: ip => ip != null ? /*#__PURE__*/_react.default.createElement(_links.NetworkDetailsLink, {
        ip: ip
      }) : (0, _empty_value.getEmptyTagValue)()
    })
  }], [data]);
  const [userRiskLevel] = (0, _react.useMemo)(() => {
    const userRiskData = userRisk && userRisk.length > 0 ? userRisk[0] : undefined;
    return [{
      title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.USER_RISK_CLASSIFICATION, /*#__PURE__*/_react.default.createElement(StyledEuiBetaBadge, {
        label: _translations2.TECHNICAL_PREVIEW_TITLE,
        size: "s",
        iconType: "beaker",
        tooltipContent: _translations2.TECHNICAL_PREVIEW_MESSAGE,
        tooltipPosition: "bottom",
        "data-test-subj": _test_ids.TECHNICAL_PREVIEW_ICON_TEST_ID
      })),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, userRiskData ? /*#__PURE__*/_react.default.createElement(_common.RiskScore, {
        severity: userRiskData.user.risk.calculated_level
      }) : /*#__PURE__*/_react.default.createElement(_common.RiskScore, {
        severity: _search_strategy.RiskSeverity.unknown
      }))
    }];
  }, [userRisk]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": _test_ids.ENTITIES_USER_OVERVIEW_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_overview_description_list.OverviewDescriptionList, {
    dataTestSubj: _test_ids.ENTITIES_USER_OVERVIEW_IP_TEST_ID,
    descriptionList: descriptionList
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isLicenseValid && /*#__PURE__*/_react.default.createElement(_page.DescriptionListStyled, {
    "data-test-subj": _test_ids.ENTITIES_USER_OVERVIEW_RISK_LEVEL_TEST_ID,
    listItems: [userRiskLevel]
  })));
};
exports.UserEntityOverview = UserEntityOverview;
UserEntityOverview.displayName = 'UserEntityOverview';