"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VISUALIZATIONS_TITLE = exports.VIEW_ALL = exports.THREAT_MATCH_DETECTED = exports.THREAT_MATCHES_DETECTED = exports.THREAT_INTELLIGENCE_TITLE = exports.THREAT_INTELLIGENCE_TEXT = exports.THREAT_ENRICHMENTS = exports.THREAT_ENRICHMENT = exports.TECHNICAL_PREVIEW_TITLE = exports.TECHNICAL_PREVIEW_MESSAGE = exports.SEVERITY_TITLE = exports.RULE_DESCRIPTION_TITLE = exports.RISK_SCORE_TITLE = exports.INVESTIGATION_TITLE = exports.INSIGHTS_TITLE = exports.HIGHLIGHTED_FIELDS_TITLE = exports.EXPAND_DETAILS_BUTTON = exports.ENTITIES_TITLE = exports.ENTITIES_TEXT = exports.DOCUMENT_REASON_TITLE = exports.DOCUMENT_DETAILS = exports.DOCUMENT_DESCRIPTION_TITLE = exports.DOCUMENT_DESCRIPTION_EXPAND_BUTTON = exports.DOCUMENT_DESCRIPTION_COLLAPSE_BUTTON = exports.DESCRIPTION_TITLE = exports.COLLAPSE_DETAILS_BUTTON = exports.ANALYZER_PREVIEW_TITLE = exports.ANALYZER_PREVIEW_TEXT = exports.ALERT_REASON_TITLE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* Header */

const EXPAND_DETAILS_BUTTON = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.expandDetailButton', {
  defaultMessage: 'Expand alert details'
});
exports.EXPAND_DETAILS_BUTTON = EXPAND_DETAILS_BUTTON;
const COLLAPSE_DETAILS_BUTTON = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.collapseDetailButton', {
  defaultMessage: 'Collapse alert details'
});
exports.COLLAPSE_DETAILS_BUTTON = COLLAPSE_DETAILS_BUTTON;
const DOCUMENT_DETAILS = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.headerTitle', {
  defaultMessage: 'Document details'
});
exports.DOCUMENT_DETAILS = DOCUMENT_DETAILS;
const SEVERITY_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.severityTitle', {
  defaultMessage: 'Severity'
});
exports.SEVERITY_TITLE = SEVERITY_TITLE;
const RISK_SCORE_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.riskScoreTitle', {
  defaultMessage: 'Risk score'
});

/* Description section */
exports.RISK_SCORE_TITLE = RISK_SCORE_TITLE;
const DESCRIPTION_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.descriptionTitle', {
  defaultMessage: 'Description'
});
exports.DESCRIPTION_TITLE = DESCRIPTION_TITLE;
const RULE_DESCRIPTION_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.ruleDescriptionTitle', {
  defaultMessage: 'Rule description'
});
exports.RULE_DESCRIPTION_TITLE = RULE_DESCRIPTION_TITLE;
const DOCUMENT_DESCRIPTION_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.documentDescriptionTitle', {
  defaultMessage: 'Document description'
});
exports.DOCUMENT_DESCRIPTION_TITLE = DOCUMENT_DESCRIPTION_TITLE;
const DOCUMENT_DESCRIPTION_EXPAND_BUTTON = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.documentDescriptionExpandButton', {
  defaultMessage: 'Expand'
});
exports.DOCUMENT_DESCRIPTION_EXPAND_BUTTON = DOCUMENT_DESCRIPTION_EXPAND_BUTTON;
const DOCUMENT_DESCRIPTION_COLLAPSE_BUTTON = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.documentDescriptionCollapseButton', {
  defaultMessage: 'Collapse'
});
exports.DOCUMENT_DESCRIPTION_COLLAPSE_BUTTON = DOCUMENT_DESCRIPTION_COLLAPSE_BUTTON;
const ALERT_REASON_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.alertReasonTitle', {
  defaultMessage: 'Alert reason'
});
exports.ALERT_REASON_TITLE = ALERT_REASON_TITLE;
const DOCUMENT_REASON_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.documentReasonTitle', {
  defaultMessage: 'Document reason'
});

/* Investigation section */
exports.DOCUMENT_REASON_TITLE = DOCUMENT_REASON_TITLE;
const INVESTIGATION_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.investigationSectionTitle', {
  defaultMessage: 'Investigation'
});
exports.INVESTIGATION_TITLE = INVESTIGATION_TITLE;
const HIGHLIGHTED_FIELDS_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.highlightedFieldsTitle', {
  defaultMessage: 'Highlighted fields'
});

/* Insights section */
exports.HIGHLIGHTED_FIELDS_TITLE = HIGHLIGHTED_FIELDS_TITLE;
const ENTITIES_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.entitiesTitle', {
  defaultMessage: 'Entities'
});
exports.ENTITIES_TITLE = ENTITIES_TITLE;
const THREAT_INTELLIGENCE_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.threatIntelligenceTitle', {
  defaultMessage: 'Threat Intelligence'
});
exports.THREAT_INTELLIGENCE_TITLE = THREAT_INTELLIGENCE_TITLE;
const INSIGHTS_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.insightsTitle', {
  defaultMessage: 'Insights'
});
exports.INSIGHTS_TITLE = INSIGHTS_TITLE;
const TECHNICAL_PREVIEW_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.technicalPreviewTitle', {
  defaultMessage: 'Technical Preview'
});
exports.TECHNICAL_PREVIEW_TITLE = TECHNICAL_PREVIEW_TITLE;
const TECHNICAL_PREVIEW_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.technicalPreviewMessage', {
  defaultMessage: 'This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will take a best effort approach to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.'
});
exports.TECHNICAL_PREVIEW_MESSAGE = TECHNICAL_PREVIEW_MESSAGE;
const ENTITIES_TEXT = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.entitiesText', {
  defaultMessage: 'entities'
});
exports.ENTITIES_TEXT = ENTITIES_TEXT;
const THREAT_INTELLIGENCE_TEXT = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.threatIntelligenceText', {
  defaultMessage: 'fields of threat intelligence'
});
exports.THREAT_INTELLIGENCE_TEXT = THREAT_INTELLIGENCE_TEXT;
const THREAT_MATCH_DETECTED = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.threatIntelligence.threatMatch', {
  defaultMessage: `threat match detected`
});
exports.THREAT_MATCH_DETECTED = THREAT_MATCH_DETECTED;
const THREAT_MATCHES_DETECTED = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.threatIntelligence.threatMatches', {
  defaultMessage: `threat matches detected`
});
exports.THREAT_MATCHES_DETECTED = THREAT_MATCHES_DETECTED;
const THREAT_ENRICHMENT = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.threatIntelligence.threatEnrichment', {
  defaultMessage: `field enriched with threat intelligence`
});
exports.THREAT_ENRICHMENT = THREAT_ENRICHMENT;
const THREAT_ENRICHMENTS = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.threatIntelligence.threatEnrichments', {
  defaultMessage: `fields enriched with threat intelligence`
});
exports.THREAT_ENRICHMENTS = THREAT_ENRICHMENTS;
const VIEW_ALL = text => _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.viewAllButton', {
  values: {
    text
  },
  defaultMessage: 'View all {text}'
});
exports.VIEW_ALL = VIEW_ALL;
const VISUALIZATIONS_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.visualizationsTitle', {
  defaultMessage: 'Visualizations'
});
exports.VISUALIZATIONS_TITLE = VISUALIZATIONS_TITLE;
const ANALYZER_PREVIEW_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.analyzerPreviewTitle', {
  defaultMessage: 'Analyzer preview'
});
exports.ANALYZER_PREVIEW_TITLE = ANALYZER_PREVIEW_TITLE;
const ANALYZER_PREVIEW_TEXT = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.analyzerPreviewText', {
  defaultMessage: 'analyzer preview.'
});
exports.ANALYZER_PREVIEW_TEXT = ANALYZER_PREVIEW_TEXT;