"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentSeverity = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _translations = require("./translations");
var _context = require("../context");
var _severity_badge = require("../../../detections/components/rules/severity_badge");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isSeverity = x => x === 'low' || x === 'medium' || x === 'high' || x === 'critical';

/**
 * Document details severity displayed in flyout right section header
 */
const DocumentSeverity = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    getFieldsData
  } = (0, _context.useRightPanelContext)();
  const fieldsData = getFieldsData(_ruleDataUtils.ALERT_SEVERITY);
  if (!fieldsData) {
    return null;
  }
  let alertSeverity;
  if (typeof fieldsData === 'string' && isSeverity(fieldsData)) {
    alertSeverity = fieldsData;
  } else if (Array.isArray(fieldsData) && fieldsData.length > 0 && isSeverity(fieldsData[0])) {
    alertSeverity = fieldsData[0];
  } else {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    direction: "row",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    "data-test-subj": _test_ids.FLYOUT_HEADER_SEVERITY_TITLE_TEST_ID
  }, /*#__PURE__*/_react.default.createElement("h5", null, `${_translations.SEVERITY_TITLE}:`))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_severity_badge.SeverityBadge, {
    value: alertSeverity
  })));
});
exports.DocumentSeverity = DocumentSeverity;
DocumentSeverity.displayName = 'DocumentSeverity';