"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Reason = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _test_ids = require("./test_ids");
var _translations = require("./translations");
var _helpers = require("../../../timelines/components/side_panel/event_details/helpers");
var _renderers = require("../../../timelines/components/timeline/body/renderers");
var _get_row_renderer = require("../../../timelines/components/timeline/body/renderers/get_row_renderer");
var _context = require("../context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Displays the information provided by the rowRenderer. Supports multiple types of documents.
 */
const Reason = () => {
  const {
    dataAsNestedObject,
    dataFormattedForFieldBrowser
  } = (0, _context.useRightPanelContext)();
  const {
    isAlert
  } = (0, _helpers.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const renderer = (0, _react.useMemo)(() => dataAsNestedObject != null ? (0, _get_row_renderer.getRowRenderer)({
    data: dataAsNestedObject,
    rowRenderers: _renderers.defaultRowRenderers
  }) : null, [dataAsNestedObject]);
  if (!dataFormattedForFieldBrowser || !dataAsNestedObject || !renderer) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.REASON_TITLE_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, isAlert ? _translations.ALERT_REASON_TITLE : _translations.DOCUMENT_REASON_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.REASON_DETAILS_TEST_ID
  }, renderer.renderRow({
    contextId: 'event-details',
    data: dataAsNestedObject,
    isDraggable: false,
    scopeId: 'global'
  })));
};
exports.Reason = Reason;
Reason.displayName = 'Reason';