"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InsightsSubSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Presentational component to handle loading and error in the subsections of the Insights section.
 * Should be used for Entities, Threat Intelligence, Prevalence, Correlations and Results
 */
const InsightsSubSection = ({
  loading = false,
  error = false,
  title,
  'data-test-subj': dataTestSubj,
  children
}) => {
  const loadingDataTestSubj = `${dataTestSubj}Loading`;
  // showing the loading in this component instead of SummaryPanel because we're hiding the entire section if no data

  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      "data-test-subj": loadingDataTestSubj
    })));
  }

  // hide everything
  if (error || !title || !children) {
    return null;
  }
  const titleDataTestSubj = `${dataTestSubj}Title`;
  const contentDataTestSubj = `${dataTestSubj}Content`;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    "data-test-subj": titleDataTestSubj
  }, /*#__PURE__*/_react.default.createElement("h5", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": contentDataTestSubj,
    direction: "column",
    gutterSize: "s"
  }, children));
};
exports.InsightsSubSection = InsightsSubSection;
InsightsSubSection.displayName = 'InsightsSubSection';