"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InsightsSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _threat_intelligence_overview = require("./threat_intelligence_overview");
var _test_ids = require("./test_ids");
var _translations = require("./translations");
var _entities_overview = require("./entities_overview");
var _expandable_section = require("./expandable_section");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Insights section under overview tab. It contains entities, threat intelligence, prevalence and correlations.
 */
const InsightsSection = ({
  expanded = false
}) => {
  return /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    title: _translations.INSIGHTS_TITLE,
    expanded: expanded,
    "data-test-subj": _test_ids.INSIGHTS_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_entities_overview.EntitiesOverview, null), /*#__PURE__*/_react.default.createElement(_threat_intelligence_overview.ThreatIntelligenceOverview, null));
};
exports.InsightsSection = InsightsSection;
InsightsSection.displayName = 'InsightsSection';