"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HEADER_TEST_ID = exports.ExpandableSection = exports.CONTENT_TEST_ID = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HEADER_TEST_ID = 'Header';
exports.HEADER_TEST_ID = HEADER_TEST_ID;
const CONTENT_TEST_ID = 'Content';
exports.CONTENT_TEST_ID = CONTENT_TEST_ID;
/**
 * Component used to render multiple sections in the Overview tab
 * - Description
 * - Investigation
 * - Visualizations
 * - Insights
 */
const ExpandableSection = ({
  expanded,
  title,
  children,
  'data-test-subj': dataTestSub
}) => {
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'accordion'
  });
  const headerDataTestSub = dataTestSub + HEADER_TEST_ID;
  const contentDataTestSub = dataTestSub + CONTENT_TEST_ID;
  const header = /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": headerDataTestSub
  }, /*#__PURE__*/_react.default.createElement("h4", null, title));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: accordionId,
    buttonContent: header,
    initialIsOpen: expanded
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column",
    "data-test-subj": contentDataTestSub
  }, children));
};
exports.ExpandableSection = ExpandableSection;
ExpandableSection.displayName = 'ExpandableSection';