"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandDetailButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _test_ids = require("./test_ids");
var _left = require("../../left");
var _context = require("../context");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Button displayed in the top left corner of the panel, to expand the left section of the document details expandable flyout
 */
const ExpandDetailButton = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    closeLeftPanel,
    openLeftPanel,
    panels
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const isExpanded = panels.left != null;
  const {
    eventId,
    indexName
  } = (0, _context.useRightPanelContext)();
  const expandDetails = () => {
    openLeftPanel({
      id: _left.LeftPanelKey,
      params: {
        id: eventId,
        indexName
      }
    });
  };
  const collapseDetails = () => closeLeftPanel();
  return isExpanded ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconSide: "left",
    onClick: collapseDetails,
    iconType: "arrowEnd",
    "data-test-subj": _test_ids.COLLAPSE_DETAILS_BUTTON_TEST_ID
  }, _translations.COLLAPSE_DETAILS_BUTTON) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconSide: "left",
    onClick: expandDetails,
    iconType: "arrowStart",
    "data-test-subj": _test_ids.EXPAND_DETAILS_BUTTON_TEST_ID
  }, _translations.EXPAND_DETAILS_BUTTON);
});
exports.ExpandDetailButton = ExpandDetailButton;
ExpandDetailButton.displayName = 'ExpandDetailButton';