"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Panel component to display user or host information.
 */
const EntityPanel = ({
  title,
  iconType,
  content,
  expandable = false,
  expanded = false
}) => {
  const [toggleStatus, setToggleStatus] = (0, _react.useState)(expanded);
  const toggleQuery = (0, _react.useCallback)(() => {
    setToggleStatus(!toggleStatus);
  }, [setToggleStatus, toggleStatus]);
  const toggleIcon = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": _test_ids.ENTITY_PANEL_TOGGLE_BUTTON_TEST_ID,
    "aria-label": `entity-toggle`,
    color: "text",
    display: "empty",
    iconType: toggleStatus ? 'arrowDown' : 'arrowRight',
    onClick: toggleQuery,
    size: "s"
  })), [toggleStatus, toggleQuery]);
  const icon = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": _test_ids.ENTITY_PANEL_ICON_TEST_ID,
      "aria-label": 'entity-icon',
      color: "text",
      display: "empty",
      iconType: iconType,
      size: "s"
    });
  }, [iconType]);
  const showContent = (0, _react.useMemo)(() => {
    if (!content) {
      return false;
    }
    return !expandable || expandable && toggleStatus;
  }, [content, expandable, toggleStatus]);
  const panelHeader = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs",
      "data-test-subj": _test_ids.ENTITY_PANEL_HEADER_TEST_ID
    }, expandable && content && toggleIcon, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, icon), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxxs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, title))));
  }, [title, icon, content, toggleIcon, expandable]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    grow: true,
    hasBorder: true,
    "data-test-subj": _test_ids.ENTITY_PANEL_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    color: "subdued",
    paddingSize: "xs"
  }, panelHeader), showContent && /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": _test_ids.ENTITY_PANEL_CONTENT_TEST_ID
  }, content)));
};
exports.EntityPanel = EntityPanel;
EntityPanel.displayName = 'EntityPanel';