"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DescriptionSection = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _expandable_section = require("./expandable_section");
var _test_ids = require("./test_ids");
var _translations = require("./translations");
var _description = require("./description");
var _reason = require("./reason");
var _mitre_attack = require("./mitre_attack");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Most top section of the overview tab. It contains the description, reason and mitre attack information (for a document of type alert).
 */
const DescriptionSection = ({
  expanded = true
}) => {
  return /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    expanded: expanded,
    title: _translations.DESCRIPTION_TITLE,
    "data-test-subj": _test_ids.DESCRIPTION_SECTION_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_description.Description, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_reason.Reason, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_mitre_attack.MitreAttack, null));
};
exports.DescriptionSection = DescriptionSection;
DescriptionSection.displayName = 'DescriptionSection';