"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Description = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _context = require("../context");
var _helpers = require("../../../timelines/components/side_panel/event_details/helpers");
var _test_ids = require("./test_ids");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Displays the description of a document.
 * If the document is an alert we show the rule description. If the document is of another type, we show -.
 * By default, the text is truncated to only shows 2 lines.
 * The Expand/Collapse button allows the user to see the whole description.
 */
const Description = ({
  expanded = false
}) => {
  const [isExpanded, setIsExpanded] = (0, _react.useState)(expanded);
  const {
    dataFormattedForFieldBrowser
  } = (0, _context.useRightPanelContext)();
  const {
    isAlert,
    ruleDescription
  } = (0, _helpers.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  if (!dataFormattedForFieldBrowser) {
    return null;
  }
  const hasRuleDescription = ruleDescription && ruleDescription.length > 0;

  // TODO look into hiding the expand/collapse button if the description is short
  //  see https://github.com/elastic/security-team/issues/6248

  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.DESCRIPTION_TITLE_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, isAlert ? _translations.RULE_DESCRIPTION_TITLE : _translations.DOCUMENT_DESCRIPTION_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.DESCRIPTION_DETAILS_TEST_ID,
    css: (0, _react2.css)`
              word-break: break-word;
              ${!isExpanded && `
              display: -webkit-box;
              -webkit-line-clamp: 2;
              -webkit-box-orient: vertical;
              overflow: hidden;
              `}
            `
  }, hasRuleDescription ? ruleDescription : '-'), hasRuleDescription ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    onClick: () => setIsExpanded(preIsExpanded => !preIsExpanded),
    "data-test-subj": _test_ids.DESCRIPTION_EXPAND_BUTTON_TEST_ID
  }, isExpanded ? _translations.DOCUMENT_DESCRIPTION_COLLAPSE_BUTTON : _translations.DOCUMENT_DESCRIPTION_EXPAND_BUTTON)) : null)));
};
exports.Description = Description;
Description.displayName = 'Description';