"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InsightsTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _test_ids = require("./test_ids");
var _translations = require("./translations");
var _entities_details = require("../components/entities_details");
var _threat_intelligence_details = require("../components/threat_intelligence_details");
var _prevalence_details = require("../components/prevalence_details");
var _correlations_details = require("../components/correlations_details");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const insightsButtons = [{
  id: _entities_details.ENTITIES_TAB_ID,
  label: _translations.ENTITIES_BUTTON,
  'data-test-subj': _test_ids.INSIGHTS_TAB_ENTITIES_BUTTON_TEST_ID
}, {
  id: _threat_intelligence_details.THREAT_INTELLIGENCE_TAB_ID,
  label: _translations.THREAT_INTELLIGENCE_BUTTON,
  'data-test-subj': _test_ids.INSIGHTS_TAB_THREAT_INTELLIGENCE_BUTTON_TEST_ID
}, {
  id: _prevalence_details.PREVALENCE_TAB_ID,
  label: _translations.PREVALENCE_BUTTON,
  'data-test-subj': _test_ids.INSIGHTS_TAB_PREVALENCE_BUTTON_TEST_ID
}, {
  id: _correlations_details.CORRELATIONS_TAB_ID,
  label: _translations.CORRELATIONS_BUTTON,
  'data-test-subj': _test_ids.INSIGHTS_TAB_CORRELATIONS_BUTTON_TEST_ID
}];

/**
 * Insights view displayed in the document details expandable flyout left section
 */
const InsightsTab = /*#__PURE__*/(0, _react.memo)(() => {
  const [activeInsightsId, setActiveInsightsId] = (0, _react.useState)(_entities_details.ENTITIES_TAB_ID);
  const onChangeCompressed = optionId => {
    setActiveInsightsId(optionId);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    color: "primary",
    name: "coarsness",
    legend: _translations.INSIGHTS_BUTTONGROUP_OPTIONS,
    options: insightsButtons,
    idSelected: activeInsightsId,
    onChange: id => onChangeCompressed(id),
    buttonSize: "compressed",
    isFullWidth: true,
    "data-test-subj": _test_ids.INSIGHTS_TAB_BUTTON_GROUP_TEST_ID
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), activeInsightsId === _entities_details.ENTITIES_TAB_ID && /*#__PURE__*/_react.default.createElement(_entities_details.EntitiesDetails, null), activeInsightsId === _threat_intelligence_details.THREAT_INTELLIGENCE_TAB_ID && /*#__PURE__*/_react.default.createElement(_threat_intelligence_details.ThreatIntelligenceDetails, null), activeInsightsId === _prevalence_details.PREVALENCE_TAB_ID && /*#__PURE__*/_react.default.createElement(_prevalence_details.PrevalenceDetails, null), activeInsightsId === _correlations_details.CORRELATIONS_TAB_ID && /*#__PURE__*/_react.default.createElement(_correlations_details.CorrelationsDetails, null));
});
exports.InsightsTab = InsightsTab;
InsightsTab.displayName = 'InsightsTab';