"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLeftPanelContext = exports.LeftPanelProvider = exports.LeftFlyoutContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _constants = require("../../../common/constants");
var _model = require("../../common/store/sourcerer/model");
var _sourcerer = require("../../common/containers/sourcerer");
var _details = require("../../timelines/containers/details");
var _use_get_fields_data = require("../../common/hooks/use_get_fields_data");
var _use_route_spy = require("../../common/utils/route/use_route_spy");
var _use_space_id = require("../../common/hooks/use_space_id");
var _helpers = require("../../timelines/components/side_panel/event_details/helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LeftFlyoutContext = /*#__PURE__*/(0, _react.createContext)(undefined);
exports.LeftFlyoutContext = LeftFlyoutContext;
const LeftPanelProvider = ({
  id,
  indexName,
  children
}) => {
  var _getAlertIndexAlias;
  const currentSpaceId = (0, _use_space_id.useSpaceId)();
  const eventIndex = indexName ? (_getAlertIndexAlias = (0, _helpers.getAlertIndexAlias)(indexName, currentSpaceId)) !== null && _getAlertIndexAlias !== void 0 ? _getAlertIndexAlias : indexName : '';
  const [{
    pageName
  }] = (0, _use_route_spy.useRouteSpy)();
  const sourcererScope = pageName === _constants.SecurityPageName.detections ? _model.SourcererScopeName.detections : _model.SourcererScopeName.default;
  const sourcererDataView = (0, _sourcerer.useSourcererDataView)(sourcererScope);
  const [loading, _, searchHit] = (0, _details.useTimelineEventsDetails)({
    indexName: eventIndex,
    eventId: id !== null && id !== void 0 ? id : '',
    runtimeMappings: sourcererDataView.runtimeMappings,
    skip: !id
  });
  const getFieldsData = (0, _use_get_fields_data.useGetFieldsData)(searchHit === null || searchHit === void 0 ? void 0 : searchHit.fields);
  const contextValue = (0, _react.useMemo)(() => id && indexName ? {
    eventId: id,
    indexName,
    getFieldsData
  } : undefined, [id, indexName, getFieldsData]);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: (0, _react2.css)`
          align-items: center;
          justify-content: center;
        `
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xxl"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(LeftFlyoutContext.Provider, {
    value: contextValue
  }, children);
};
exports.LeftPanelProvider = LeftPanelProvider;
const useLeftPanelContext = () => {
  const contextValue = (0, _react.useContext)(LeftFlyoutContext);
  if (!contextValue) {
    throw new Error('LeftPanelContext can only be used within LeftPanelContext provider');
  }
  return contextValue;
};
exports.useLeftPanelContext = useLeftPanelContext;