"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SessionView = exports.SESSION_VIEW_ID = exports.SESSION_START_TIME = exports.SESSION_ENTITY_ID = exports.KIBANA_ANCESTOR_INDEX = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _utils = require("../../shared/utils");
var _translations = require("../../shared/translations");
var _translations2 = require("./translations");
var _test_ids = require("./test_ids");
var _kibana = require("../../../common/lib/kibana");
var _context = require("../context");
var _helpers = require("../../../common/components/header_actions/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SESSION_VIEW_ID = 'session_view';
exports.SESSION_VIEW_ID = SESSION_VIEW_ID;
const SESSION_ENTITY_ID = 'process.entry_leader.entity_id';
exports.SESSION_ENTITY_ID = SESSION_ENTITY_ID;
const SESSION_START_TIME = 'process.entry_leader.start';
exports.SESSION_START_TIME = SESSION_START_TIME;
const KIBANA_ANCESTOR_INDEX = 'kibana.alert.ancestors.index';

/**
 * Session view displayed in the document details expandable flyout left section under the Visualize tab
 */
exports.KIBANA_ANCESTOR_INDEX = KIBANA_ANCESTOR_INDEX;
const SessionView = () => {
  const {
    sessionView
  } = (0, _kibana.useKibana)().services;
  const {
    getFieldsData,
    indexName
  } = (0, _context.useLeftPanelContext)();
  const processIndex = (0, _helpers.getSessionViewProcessIndex)((0, _utils.getField)(getFieldsData(KIBANA_ANCESTOR_INDEX)) || indexName);
  const sessionEntityId = (0, _utils.getField)(getFieldsData(SESSION_ENTITY_ID));
  const sessionStartTime = (0, _utils.getField)(getFieldsData(SESSION_START_TIME));
  if (!processIndex || !sessionEntityId || !sessionStartTime) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "error",
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", null, (0, _translations.ERROR_TITLE)(_translations2.SESSION_VIEW_ERROR_MESSAGE)),
      body: /*#__PURE__*/_react.default.createElement("p", null, (0, _translations.ERROR_MESSAGE)(_translations2.SESSION_VIEW_ERROR_MESSAGE)),
      "data-test-subj": _test_ids.SESSION_VIEW_ERROR_TEST_ID
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.SESSION_VIEW_TEST_ID
  }, sessionView.getSessionView({
    processIndex,
    sessionEntityId,
    sessionStartTime,
    isFullScreen: true
  }));
};
exports.SessionView = SessionView;
SessionView.displayName = 'SessionView';