"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyzeGraph = exports.ANALYZE_GRAPH_ID = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("./translations");
var _context = require("../context");
var _test_ids = require("./test_ids");
var _view = require("../../../resolver/view");
var _use_timeline_data_filters = require("../../../timelines/containers/use_timeline_data_filters");
var _translations2 = require("../../shared/translations");
var _helpers = require("../../../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ANALYZE_GRAPH_ID = 'analyze_graph';

/**
 * Analyzer graph view displayed in the document details expandable flyout left section under the Visualize tab
 */
exports.ANALYZE_GRAPH_ID = ANALYZE_GRAPH_ID;
const AnalyzeGraph = () => {
  const {
    eventId
  } = (0, _context.useLeftPanelContext)();
  const scopeId = 'flyout'; // TO-DO: update to use context
  const {
    from,
    to,
    shouldUpdate,
    selectedPatterns
  } = (0, _use_timeline_data_filters.useTimelineDataFilters)((0, _helpers.isActiveTimeline)(scopeId));
  if (!eventId) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "error",
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", null, (0, _translations2.ERROR_TITLE)(_translations.ANALYZER_ERROR_MESSAGE)),
      body: /*#__PURE__*/_react.default.createElement("p", null, (0, _translations2.ERROR_MESSAGE)(_translations.ANALYZER_ERROR_MESSAGE)),
      "data-test-subj": _test_ids.ANALYZE_GRAPH_ERROR_TEST_ID
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.ANALYZER_GRAPH_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_view.Resolver, {
    databaseDocumentID: eventId,
    resolverComponentInstanceID: scopeId,
    indices: selectedPatterns,
    shouldUpdate: shouldUpdate,
    filters: {
      from,
      to
    }
  }));
};
exports.AnalyzeGraph = AnalyzeGraph;
AnalyzeGraph.displayName = 'AnalyzeGraph';