"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.expandableFlyoutDocumentsPanels = void 0;
var _react = _interopRequireDefault(require("react"));
var _right = require("./right");
var _context = require("./right/context");
var _left = require("./left");
var _context2 = require("./left/context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * List of all panels that will be used within the document details expandable flyout.
 * This needs to be passed to the expandable flyout registeredPanels property.
 */
const expandableFlyoutDocumentsPanels = [{
  key: _right.RightPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_context.RightPanelProvider, props.params, /*#__PURE__*/_react.default.createElement(_right.RightPanel, {
    path: props.path
  }))
}, {
  key: _left.LeftPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_context2.LeftPanelProvider, props.params, /*#__PURE__*/_react.default.createElement(_left.LeftPanel, {
    path: props.path
  }))
}];
exports.expandableFlyoutDocumentsPanels = expandableFlyoutDocumentsPanels;