"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UsersTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _formatted_date = require("../../../../common/components/formatted_date");
var _links = require("../../../../common/components/links");
var _empty_value = require("../../../../common/components/empty_value");
var _paginated_table = require("../../../components/paginated_table");
var _helpers = require("../../../../common/components/tables/helpers");
var _use_selector = require("../../../../common/hooks/use_selector");
var i18n = _interopRequireWildcard(require("./translations"));
var _store = require("../../store");
var _common = require("../../../components/risk_score/severity/common");
var _use_ml_capabilities = require("../../../../common/components/ml/hooks/use_ml_capabilities");
var _translations2 = require("../user_risk_score_table/translations");
var _types = require("../../../../app/types");
var _model = require("../../store/model");
var _kibana = require("../../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tableType = _store.usersModel.UsersTableType.allUsers;
const rowItems = [{
  text: i18n.ROWS_5,
  numberOfRow: 5
}, {
  text: i18n.ROWS_10,
  numberOfRow: 10
}];
const getUsersColumns = (showRiskColumn, dispatchSeverityUpdate) => {
  const columns = [{
    field: 'name',
    name: i18n.USER_NAME,
    truncateText: false,
    sortable: true,
    mobileOptions: {
      show: true
    },
    render: name => name != null && name.length > 0 ? (0, _helpers.getRowItemsWithActions)({
      fieldName: 'user.name',
      values: [name],
      idPrefix: `users-table-${name}-name`,
      render: item => /*#__PURE__*/_react.default.createElement(_links.UserDetailsLink, {
        userName: item
      }),
      aggregatable: true,
      fieldType: 'keyword'
    }) : (0, _empty_value.getOrEmptyTagFromValue)(name)
  }, {
    field: 'lastSeen',
    name: i18n.LAST_SEEN,
    sortable: true,
    truncateText: false,
    mobileOptions: {
      show: true
    },
    render: lastSeen => /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
      value: lastSeen
    })
  }, {
    field: 'domain',
    name: i18n.DOMAIN,
    sortable: false,
    truncateText: false,
    mobileOptions: {
      show: true
    },
    render: domain => domain != null && domain.length > 0 ? (0, _helpers.getRowItemsWithActions)({
      fieldName: 'user.domain',
      values: [domain],
      idPrefix: `users-table-${domain}-domain`,
      aggregatable: true,
      fieldType: 'keyword'
    }) : (0, _empty_value.getOrEmptyTagFromValue)(domain)
  }];
  if (showRiskColumn) {
    columns.push({
      field: 'risk',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: i18n.USER_RISK_TOOLTIP
      }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.USER_RISK, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        color: "subdued",
        type: "iInCircle",
        className: "eui-alignTop"
      }))),
      truncateText: false,
      mobileOptions: {
        show: true
      },
      sortable: false,
      render: riskScore => {
        if (riskScore != null) {
          return /*#__PURE__*/_react.default.createElement(_common.RiskScore, {
            toolTipContent: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
              onClick: () => dispatchSeverityUpdate(riskScore)
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
              size: "xs"
            }, (0, _translations2.VIEW_USERS_BY_SEVERITY)(riskScore.toLowerCase()))),
            severity: riskScore
          });
        }
        return (0, _empty_value.getEmptyTagValue)();
      }
    });
  }
  return columns;
};
const UsersTableComponent = ({
  users,
  totalCount,
  type,
  id,
  fakeTotalCount,
  loading,
  loadPage,
  showMorePagesIndicator,
  sort,
  setQuerySkip
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getUsersSelector = (0, _react.useMemo)(() => _store.usersSelectors.allUsersSelector(), []);
  const {
    activePage,
    limit
  } = (0, _use_selector.useDeepEqualSelector)(state => getUsersSelector(state));
  const isPlatinumOrTrialLicense = (0, _use_ml_capabilities.useMlCapabilities)().isPlatinumOrTrialLicense;
  const {
    navigateTo
  } = (0, _kibana.useNavigateTo)();
  const updateLimitPagination = (0, _react.useCallback)(newLimit => {
    dispatch(_store.usersActions.updateTableLimit({
      usersType: type,
      limit: newLimit,
      tableType
    }));
  }, [type, dispatch]);
  const updateActivePage = (0, _react.useCallback)(newPage => {
    dispatch(_store.usersActions.updateTableActivePage({
      activePage: newPage,
      usersType: type,
      tableType
    }));
  }, [type, dispatch]);
  const onSort = (0, _react.useCallback)(criteria => {
    if (criteria.sort != null) {
      const newSort = criteria.sort;
      if (newSort.direction !== sort.direction || newSort.field !== sort.field) {
        dispatch(_store.usersActions.updateTableSorting({
          sort: newSort,
          tableType
        }));
      }
    }
  }, [dispatch, sort]);
  const dispatchSeverityUpdate = (0, _react.useCallback)(s => {
    dispatch(_store.usersActions.updateUserRiskScoreSeverityFilter({
      severitySelection: [s]
    }));
    navigateTo({
      deepLinkId: _types.SecurityPageName.users,
      path: _model.UsersTableType.risk
    });
  }, [dispatch, navigateTo]);
  const columns = (0, _react.useMemo)(() => getUsersColumns(isPlatinumOrTrialLicense, dispatchSeverityUpdate), [isPlatinumOrTrialLicense, dispatchSeverityUpdate]);
  return /*#__PURE__*/_react.default.createElement(_paginated_table.PaginatedTable, {
    activePage: activePage,
    columns: columns,
    dataTestSubj: `table-${tableType}`,
    headerCount: totalCount,
    headerTitle: i18n.USERS,
    headerUnit: i18n.UNIT(totalCount),
    id: id,
    itemsPerRow: rowItems,
    limit: limit,
    loading: loading,
    loadPage: loadPage,
    pageOfItems: users,
    showMorePagesIndicator: showMorePagesIndicator,
    totalCount: fakeTotalCount,
    updateLimitPagination: updateLimitPagination,
    updateActivePage: updateActivePage,
    sorting: sort,
    onChange: onSort,
    setQuerySkip: setQuerySkip
  });
};
UsersTableComponent.displayName = 'UsersTableComponent';
const UsersTable = /*#__PURE__*/_react.default.memo(UsersTableComponent);
exports.UsersTable = UsersTable;