"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkDetails = void 0;
Object.defineProperty(exports, "getTrailingBreadcrumbs", {
  enumerable: true,
  get: function () {
    return _utils2.getTrailingBreadcrumbs;
  }
});
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _common = require("@kbn/data-plugin/common");
var _esQuery = require("@kbn/es-query");
var _alerts_by_status = require("../../../../overview/components/detection_response/alerts_by_status");
var _use_signal_index = require("../../../../detections/containers/detection_engine/alerts/use_signal_index");
var _constants = require("../../../../common/store/inputs/constants");
var _use_selector = require("../../../../common/hooks/use_selector");
var _search_strategy = require("../../../../../common/search_strategy");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _filters_global = require("../../../../common/components/filters_global");
var _header_page = require("../../../../common/components/header_page");
var _last_event_time = require("../../../../common/components/last_event_time");
var _use_anomalies_table_data = require("../../../../common/components/ml/anomaly/use_anomalies_table_data");
var _network_to_criteria = require("../../../../common/components/ml/criteria/network_to_criteria");
var _score_interval_to_datetime = require("../../../../common/components/ml/score/score_interval_to_datetime");
var _manage_query = require("../../../../common/components/page/manage_query");
var _flow_target_select_connected = require("../../components/flow_target_select_connected");
var _details = require("../../components/details");
var _search_bar = require("../../../../common/components/search_bar");
var _page_wrapper = require("../../../../common/components/page_wrapper");
var _details2 = require("../../containers/details");
var _kibana = require("../../../../common/lib/kibana");
var _helpers = require("../../../../common/lib/helpers");
var _store = require("../../../../common/store");
var _actions = require("../../../../common/store/inputs/actions");
var _actions2 = require("../../store/actions");
var _spy_routes = require("../../../../common/utils/route/spy_routes");
var _store2 = require("../../store");
var _types = require("../../../../app/types");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _use_invalid_filter_query = require("../../../../common/hooks/use_invalid_filter_query");
var _landing_page = require("../../../../common/components/landing_page");
var _tab_navigation_with_breadcrumbs = require("../../../../common/components/navigation/tab_navigation_with_breadcrumbs");
var _utils = require("../../../../common/components/visualization_actions/utils");
var _has_ml_user_permissions = require("../../../../../common/machine_learning/has_ml_user_permissions");
var _alert_count_by_status = require("../../../../common/components/alert_count_by_status");
var _use_ml_capabilities = require("../../../../common/components/ml/hooks/use_ml_capabilities");
var _use_alerts_privileges = require("../../../../detections/containers/detection_engine/alerts/use_alerts_privileges");
var _nav_tabs = require("./nav_tabs");
var _details_tabs = require("./details_tabs");
var _use_installed_security_jobs = require("../../../../common/components/ml/hooks/use_installed_security_jobs");
var _cell_actions = require("../../../../common/components/cell_actions");
var _utils2 = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NetworkDetailsManage = (0, _manage_query.manageQuery)(_details.IpOverview);
const NetworkDetailsComponent = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const capabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const {
    to,
    from,
    setQuery,
    isInitializing
  } = (0, _use_global_time.useGlobalTime)();
  const {
    detailName,
    flowTarget
  } = (0, _reactRouterDom.useParams)();
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const {
    signalIndexName
  } = (0, _use_signal_index.useSignalIndex)();
  const {
    hasKibanaREAD,
    hasIndexRead
  } = (0, _use_alerts_privileges.useAlertsPrivileges)();
  const canReadAlerts = hasKibanaREAD && hasIndexRead;
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const globalFilters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const type = _store2.networkModel.NetworkType.details;
  const narrowDateRange = (0, _react.useCallback)((score, interval) => {
    const fromTo = (0, _score_interval_to_datetime.scoreIntervalToDateTime)(score, interval);
    dispatch((0, _actions.setAbsoluteRangeDatePicker)({
      id: _constants.InputsModelId.global,
      from: fromTo.from,
      to: fromTo.to
    }));
  }, [dispatch]);
  const {
    services: {
      uiSettings
    }
  } = (0, _kibana.useKibana)();
  (0, _react.useEffect)(() => {
    dispatch((0, _actions2.setNetworkDetailsTablesActivePageToZero)());
  }, [detailName, dispatch]);
  const {
    indicesExist,
    indexPattern,
    selectedPatterns
  } = (0, _sourcerer.useSourcererDataView)();
  const ip = (0, _helpers.decodeIpv6)(detailName);
  const networkDetailsFilter = (0, _react.useMemo)(() => (0, _utils.getNetworkDetailsPageFilter)(ip), [ip]);
  const [rawFilteredQuery, kqlError] = (0, _react.useMemo)(() => {
    try {
      return [(0, _esQuery.buildEsQuery)(indexPattern, [query], [...networkDetailsFilter, ...globalFilters], (0, _common.getEsQueryConfig)(uiSettings))];
    } catch (e) {
      return [undefined, e];
    }
  }, [globalFilters, indexPattern, networkDetailsFilter, query, uiSettings]);
  const stringifiedAdditionalFilters = JSON.stringify(rawFilteredQuery);
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id: _details2.ID,
    filterQuery: stringifiedAdditionalFilters,
    kqlError,
    query,
    startDate: from,
    endDate: to
  });
  const [loading, {
    id,
    inspect,
    networkDetails,
    refetch
  }] = (0, _details2.useNetworkDetails)({
    skip: isInitializing,
    filterQuery: stringifiedAdditionalFilters,
    indexNames: selectedPatterns,
    ip
  });
  const {
    jobNameById
  } = (0, _use_installed_security_jobs.useInstalledSecurityJobNameById)();
  const jobIds = (0, _react.useMemo)(() => Object.keys(jobNameById), [jobNameById]);
  const [isLoadingAnomaliesData, anomaliesData] = (0, _use_anomalies_table_data.useAnomaliesTableData)({
    criteriaFields: (0, _network_to_criteria.networkToCriteria)(detailName, flowTarget),
    startDate: from,
    endDate: to,
    skip: isInitializing,
    jobIds,
    aggregationInterval: 'auto'
  });
  const entityFilter = (0, _react.useMemo)(() => ({
    field: `${flowTarget}.ip`,
    value: detailName
  }), [detailName, flowTarget]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "network-details-page"
  }, indicesExist ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, null, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    indexPattern: indexPattern,
    id: _constants.InputsModelId.global
  })), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, null, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    border: true,
    "data-test-subj": "network-details-headline",
    subtitle: /*#__PURE__*/_react.default.createElement(_last_event_time.LastEventTime, {
      indexKey: _search_strategy.LastEventIndexKey.ipDetails,
      indexNames: selectedPatterns,
      ip: ip
    }),
    title: /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
      field: {
        type: 'ip',
        value: ip,
        name: `${flowTarget}.ip`
      },
      mode: _cell_actions.CellActionsMode.HOVER_DOWN,
      visibleCellActions: 5,
      triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT
    }, ip)
  }, /*#__PURE__*/_react.default.createElement(_flow_target_select_connected.FlowTargetSelectConnected, {
    flowTarget: flowTarget
  })), /*#__PURE__*/_react.default.createElement(NetworkDetailsManage, {
    id: id,
    inspect: inspect,
    ip: ip,
    isInDetailsSidePanel: false,
    data: networkDetails,
    anomaliesData: anomaliesData,
    loading: loading,
    isLoadingAnomaliesData: isLoadingAnomaliesData,
    type: type,
    flowTarget: flowTarget,
    refetch: refetch,
    setQuery: setQuery,
    startDate: from,
    endDate: to,
    narrowDateRange: narrowDateRange,
    indexPatterns: selectedPatterns,
    jobNameById: jobNameById
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), canReadAlerts && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_alerts_by_status.AlertsByStatus, {
    signalIndexName: signalIndexName,
    entityFilter: entityFilter,
    additionalFilters: rawFilteredQuery ? [rawFilteredQuery] : []
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_alert_count_by_status.AlertCountByRuleByStatus, {
    entityFilter: entityFilter,
    signalIndexName: signalIndexName,
    additionalFilters: rawFilteredQuery ? [rawFilteredQuery] : []
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_tab_navigation_with_breadcrumbs.TabNavigationWithBreadcrumbs, {
    navTabs: (0, _nav_tabs.navTabsNetworkDetails)(ip, (0, _has_ml_user_permissions.hasMlUserPermissions)(capabilities), flowTarget)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_details_tabs.NetworkDetailsTabs, {
    ip: ip,
    endDate: to,
    startDate: from,
    filterQuery: stringifiedAdditionalFilters,
    indexNames: selectedPatterns,
    skip: isInitializing || !!kqlError,
    setQuery: setQuery,
    indexPattern: indexPattern,
    flowTarget: flowTarget,
    networkDetailsFilter: networkDetailsFilter
  }))) : /*#__PURE__*/_react.default.createElement(_landing_page.LandingPageComponent, null), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.network
  }));
};
NetworkDetailsComponent.displayName = 'NetworkDetailsComponent';
const NetworkDetails = /*#__PURE__*/_react.default.memo(NetworkDetailsComponent);
exports.NetworkDetails = NetworkDetails;