"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNetworkHttp = exports.ID = void 0;
var _react = require("react");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _use_selector = require("../../../../common/hooks/use_selector");
var _helpers = require("../../../../common/containers/helpers");
var _helpers2 = require("../../../components/paginated_table/helpers");
var _store = require("../../store");
var _search_strategy = require("../../../../../common/search_strategy");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_search_strategy = require("../../../../common/containers/use_search_strategy");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ID = 'networkHttpQuery';
exports.ID = ID;
const useNetworkHttp = ({
  endDate,
  filterQuery,
  id,
  indexNames,
  ip,
  skip,
  startDate,
  type
}) => {
  const getHttpSelector = (0, _react.useMemo)(() => _store.networkSelectors.httpSelector(), []);
  const {
    activePage,
    limit,
    sort
  } = (0, _use_selector.useDeepEqualSelector)(state => getHttpSelector(state, type));
  const [networkHttpRequest, setHostRequest] = (0, _react.useState)(null);
  const wrappedLoadMore = (0, _react.useCallback)(newActivePage => {
    setHostRequest(prevRequest => {
      if (!prevRequest) {
        return prevRequest;
      }
      return {
        ...prevRequest,
        pagination: (0, _helpers2.generateTablePaginationOptions)(newActivePage, limit)
      };
    });
  }, [limit]);
  const {
    loading,
    result: response,
    search,
    refetch,
    inspect
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType: _search_strategy.NetworkQueries.http,
    initialResult: {
      edges: [],
      totalCount: -1,
      pageInfo: {
        activePage: 0,
        fakeTotalCount: 0,
        showMorePagesIndicator: false
      }
    },
    errorMessage: i18n.FAIL_NETWORK_HTTP,
    abort: skip
  });
  const networkHttpResponse = (0, _react.useMemo)(() => ({
    endDate,
    networkHttp: response.edges,
    id,
    inspect,
    isInspected: false,
    loadPage: wrappedLoadMore,
    pageInfo: response.pageInfo,
    refetch,
    startDate,
    totalCount: response.totalCount
  }), [endDate, id, inspect, refetch, response.edges, response.pageInfo, response.totalCount, startDate, wrappedLoadMore]);
  (0, _react.useEffect)(() => {
    setHostRequest(prevRequest => {
      const myRequest = {
        ...(prevRequest !== null && prevRequest !== void 0 ? prevRequest : {}),
        defaultIndex: indexNames,
        factoryQueryType: _search_strategy.NetworkQueries.http,
        filterQuery: (0, _helpers.createFilter)(filterQuery),
        ip,
        pagination: (0, _helpers2.generateTablePaginationOptions)(activePage, limit),
        sort: sort,
        timerange: {
          interval: '12h',
          from: startDate,
          to: endDate
        }
      };
      if (!(0, _fastDeepEqual.default)(prevRequest, myRequest)) {
        return myRequest;
      }
      return prevRequest;
    });
  }, [activePage, indexNames, endDate, filterQuery, ip, limit, startDate, sort]);
  (0, _react.useEffect)(() => {
    if (!skip && networkHttpRequest) {
      search(networkHttpRequest);
    }
  }, [networkHttpRequest, search, skip]);
  return [loading, networkHttpResponse];
};
exports.useNetworkHttp = useNetworkHttp;