"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUsersColumns = void 0;
var _empty_value = require("../../../../common/components/empty_value");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("../../../../common/components/tables/helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUsersColumns = (flowTarget, tableId) => [{
  field: 'node.user.name',
  name: i18n.USER_NAME,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: true,
  render: userName => (0, _helpers.getRowItemsWithActions)({
    values: userName ? [userName] : undefined,
    fieldName: 'user.name',
    fieldType: 'keyword',
    aggregatable: true,
    idPrefix: `${tableId}-table-${flowTarget}-user`
  })
}, {
  field: 'node.user.id',
  name: i18n.USER_ID,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: false,
  render: userIds => (0, _helpers.getRowItemsWithActions)({
    values: userIds,
    fieldName: 'user.id',
    fieldType: 'keyword',
    aggregatable: true,
    idPrefix: `${tableId}-table-${flowTarget}`
  })
}, {
  field: 'node.user.groupName',
  name: i18n.GROUP_NAME,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: false,
  render: groupNames => (0, _helpers.getRowItemsWithActions)({
    values: groupNames,
    fieldName: 'user.group.name',
    fieldType: 'keyword',
    aggregatable: true,
    idPrefix: `${tableId}-table-${flowTarget}`
  })
}, {
  field: 'node.user.groupId',
  name: i18n.GROUP_ID,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: false,
  render: groupId => (0, _helpers.getRowItemsWithActions)({
    values: groupId,
    fieldName: 'user.group.id',
    fieldType: 'keyword',
    aggregatable: true,
    idPrefix: `${tableId}-table-${flowTarget}`
  })
}, {
  align: 'right',
  field: 'node.user.count',
  name: i18n.DOCUMENT_COUNT,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: true,
  render: docCount => (0, _empty_value.defaultToEmptyTag)(docCount)
}];
exports.getUsersColumns = getUsersColumns;