"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNetworkTopNFlowColumns = exports.getNFlowColumnsCurated = void 0;
var _fp = require("lodash/fp");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _react = _interopRequireDefault(require("react"));
var _cell_actions = require("../../../../common/components/cell_actions");
var _country_flag = require("../source_destination/country_flag");
var _search_strategy = require("../../../../../common/search_strategy");
var _store = require("../../store");
var _helpers = require("../../../../common/components/drag_and_drop/helpers");
var _empty_value = require("../../../../common/components/empty_value");
var _links = require("../../../../common/components/links");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers2 = require("../../../../common/components/tables/helpers");
var _formatted_bytes = require("../../../../common/components/formatted_bytes");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getNetworkTopNFlowColumns = (flowTarget, tableId) => [{
  name: i18n.IP_TITLE,
  render: ({
    node
  }) => {
    const ipAttr = `${flowTarget}.ip`;
    const ip = (0, _fp.get)(ipAttr, node);
    const geoAttr = `${flowTarget}.location.geo.country_iso_code[0]`;
    const geoAttrName = `${flowTarget}.geo.country_iso_code`;
    const geo = (0, _fp.get)(geoAttr, node);
    const id = (0, _helpers.escapeDataProviderId)(`${tableId}-table-${flowTarget}-ip-${ip}`);
    if (ip != null) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
        key: id,
        mode: _cell_actions.CellActionsMode.HOVER_DOWN,
        visibleCellActions: 5,
        showActionTooltips: true,
        triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
        field: {
          name: ipAttr,
          value: ip,
          type: 'keyword',
          aggregatable: true
        }
      }, /*#__PURE__*/_react.default.createElement(_links.NetworkDetailsLink, {
        ip: ip,
        flowTarget: flowTarget
      })), geo && /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
        key: `${id}-${geo}`,
        mode: _cell_actions.CellActionsMode.HOVER_DOWN,
        visibleCellActions: 5,
        showActionTooltips: true,
        triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
        field: {
          name: geoAttrName,
          value: geo,
          type: 'keyword',
          aggregatable: true
        }
      }, ' ', /*#__PURE__*/_react.default.createElement(_country_flag.CountryFlag, {
        countryCode: geo
      }), " ", geo));
    } else {
      return (0, _empty_value.getEmptyTagValue)();
    }
  },
  width: '20%'
}, {
  name: i18n.DOMAIN,
  render: ({
    node
  }) => {
    const domainAttr = `${flowTarget}.domain`;
    const ipAttr = `${flowTarget}.ip`;
    const domains = (0, _fp.get)(domainAttr, node);
    const ip = (0, _fp.get)(ipAttr, node);
    if (Array.isArray(domains) && domains.length > 0) {
      const id = (0, _helpers.escapeDataProviderId)(`${tableId}-table-${ip}`);
      return (0, _helpers2.getRowItemsWithActions)({
        values: domains,
        fieldName: domainAttr,
        fieldType: 'keyword',
        aggregatable: true,
        idPrefix: id,
        displayCount: 1
      });
    } else {
      return (0, _empty_value.getEmptyTagValue)();
    }
  },
  width: '20%'
}, {
  name: i18n.AUTONOMOUS_SYSTEM,
  render: ({
    node,
    cursor: {
      value: ipAddress
    }
  }) => {
    const asAttr = `${flowTarget}.autonomous_system`;
    const as = (0, _fp.get)(asAttr, node);
    if (as != null) {
      const id = (0, _helpers.escapeDataProviderId)(`${tableId}-table-${flowTarget}-ip-${ipAddress}`);
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, as.name && (0, _helpers2.getRowItemsWithActions)({
        values: [as.name],
        fieldName: `${flowTarget}.as.organization.name`,
        fieldType: 'keyword',
        aggregatable: true,
        idPrefix: `${id}-name`
      }), as.number && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' ', (0, _helpers2.getRowItemsWithActions)({
        values: [`${as.number}`],
        fieldName: `${flowTarget}.as.number`,
        idPrefix: `${id}-number`,
        fieldType: 'keyword',
        aggregatable: true
      })));
    } else {
      return (0, _empty_value.getEmptyTagValue)();
    }
  },
  width: '20%'
}, {
  align: 'right',
  field: 'node.network.bytes_in',
  name: i18n.BYTES_IN,
  sortable: true,
  render: bytes => {
    if (bytes != null) {
      return /*#__PURE__*/_react.default.createElement(_formatted_bytes.PreferenceFormattedBytes, {
        value: bytes
      });
    } else {
      return (0, _empty_value.getEmptyTagValue)();
    }
  }
}, {
  align: 'right',
  field: 'node.network.bytes_out',
  name: i18n.BYTES_OUT,
  sortable: true,
  render: bytes => {
    if (bytes != null) {
      return /*#__PURE__*/_react.default.createElement(_formatted_bytes.PreferenceFormattedBytes, {
        value: bytes
      });
    } else {
      return (0, _empty_value.getEmptyTagValue)();
    }
  }
}, {
  align: 'right',
  field: `node.${flowTarget}.flows`,
  name: i18n.FLOWS,
  sortable: true,
  render: flows => {
    if (flows != null) {
      return (0, _numeral.default)(flows).format('0,000');
    } else {
      return (0, _empty_value.getEmptyTagValue)();
    }
  }
}, {
  align: 'right',
  field: `node.${flowTarget}.${getOppositeField(flowTarget)}_ips`,
  name: flowTarget === _search_strategy.FlowTargetSourceDest.source ? i18n.DESTINATION_IPS : i18n.SOURCE_IPS,
  sortable: true,
  render: ips => {
    if (ips != null) {
      return (0, _numeral.default)(ips).format('0,000');
    } else {
      return (0, _empty_value.getEmptyTagValue)();
    }
  }
}];
exports.getNetworkTopNFlowColumns = getNetworkTopNFlowColumns;
const getNFlowColumnsCurated = (flowTarget, type, tableId) => {
  const columns = getNetworkTopNFlowColumns(flowTarget, tableId);

  // Columns to exclude from host details pages
  if (type === _store.networkModel.NetworkType.details) {
    columns.pop();
    return columns;
  }
  return columns;
};
exports.getNFlowColumnsCurated = getNFlowColumnsCurated;
const getOppositeField = flowTarget => flowTarget === _search_strategy.FlowTargetSourceDest.source ? _search_strategy.FlowTargetSourceDest.destination : _search_strategy.FlowTargetSourceDest.source;