"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNetworkHttpColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _network = require("../../../../../common/search_strategy/security_solution/network");
var _helpers = require("../../../../common/components/drag_and_drop/helpers");
var _empty_value = require("../../../../common/components/empty_value");
var _links = require("../../../../common/components/links");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers2 = require("../../../../common/components/tables/helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getNetworkHttpColumns = tableId => [{
  name: i18n.METHOD,
  render: ({
    node: {
      methods,
      path
    }
  }) => {
    return Array.isArray(methods) && methods.length > 0 ? (0, _helpers2.getRowItemsWithActions)({
      fieldName: 'http.request.method',
      values: methods,
      idPrefix: (0, _helpers.escapeDataProviderId)(`${tableId}-table-methods-${path}`),
      fieldType: 'keyword',
      aggregatable: true,
      displayCount: 3
    }) : (0, _empty_value.getEmptyTagValue)();
  }
}, {
  name: i18n.DOMAIN,
  render: ({
    node: {
      domains,
      path
    }
  }) => Array.isArray(domains) && domains.length > 0 ? (0, _helpers2.getRowItemsWithActions)({
    values: domains,
    fieldName: 'url.domain',
    idPrefix: (0, _helpers.escapeDataProviderId)(`${tableId}-table-domains-${path}`),
    fieldType: 'keyword',
    aggregatable: true
  }) : (0, _empty_value.getEmptyTagValue)()
}, {
  field: `node.${_network.NetworkHttpFields.path}`,
  name: i18n.PATH,
  render: path => path != null ? (0, _helpers2.getRowItemsWithActions)({
    values: [path],
    fieldName: 'url.path',
    idPrefix: (0, _helpers.escapeDataProviderId)(`${tableId}-table-path-${path}`),
    fieldType: 'keyword',
    aggregatable: true
  }) : (0, _empty_value.getEmptyTagValue)()
}, {
  name: i18n.STATUS,
  render: ({
    node: {
      statuses,
      path
    }
  }) => Array.isArray(statuses) && statuses.length > 0 ? (0, _helpers2.getRowItemsWithActions)({
    values: statuses,
    fieldName: 'http.response.status_code',
    idPrefix: (0, _helpers.escapeDataProviderId)(`${tableId}-table-statuses-${path}`),
    fieldType: 'keyword',
    aggregatable: true,
    displayCount: 3
  }) : (0, _empty_value.getEmptyTagValue)()
}, {
  name: i18n.LAST_HOST,
  render: ({
    node: {
      lastHost,
      path
    }
  }) => lastHost != null ? (0, _helpers2.getRowItemsWithActions)({
    values: [lastHost],
    fieldName: 'host.name',
    idPrefix: (0, _helpers.escapeDataProviderId)(`${tableId}-table-lastHost-${path}`),
    fieldType: 'keyword',
    aggregatable: true
  }) : (0, _empty_value.getEmptyTagValue)()
}, {
  name: i18n.LAST_SOURCE_IP,
  render: ({
    node: {
      lastSourceIp,
      path
    }
  }) => lastSourceIp != null ? (0, _helpers2.getRowItemsWithActions)({
    values: [lastSourceIp],
    fieldName: 'source.ip',
    idPrefix: (0, _helpers.escapeDataProviderId)(`${tableId}-table-lastSourceIp-${path}`),
    fieldType: 'keyword',
    aggregatable: true,
    render: () => /*#__PURE__*/_react.default.createElement(_links.NetworkDetailsLink, {
      ip: lastSourceIp
    })
  }) : (0, _empty_value.getEmptyTagValue)()
}, {
  align: 'right',
  field: `node.${_network.NetworkHttpFields.requestCount}`,
  name: i18n.REQUESTS,
  sortable: true,
  render: requestCount => {
    if (requestCount != null) {
      return (0, _numeral.default)(requestCount).format('0,000');
    } else {
      return (0, _empty_value.getEmptyTagValue)();
    }
  }
}];
exports.getNetworkHttpColumns = getNetworkHttpColumns;