"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNetworkDnsColumns = void 0;
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _react = _interopRequireDefault(require("react"));
var _cell_actions = require("../../../../common/components/cell_actions");
var _search_strategy = require("../../../../../common/search_strategy");
var _helpers = require("../../../../common/components/drag_and_drop/helpers");
var _empty_value = require("../../../../common/components/empty_value");
var _formatted_bytes = require("../../../../common/components/formatted_bytes");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getNetworkDnsColumns = () => [{
  field: `node.${_search_strategy.NetworkDnsFields.dnsName}`,
  name: i18n.REGISTERED_DOMAIN,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: true,
  render: dnsName => {
    if (dnsName != null) {
      return /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
        key: (0, _helpers.escapeDataProviderId)(`networkDns-table--name-${dnsName}`),
        mode: _cell_actions.CellActionsMode.HOVER_DOWN,
        visibleCellActions: 5,
        showActionTooltips: true,
        triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
        field: {
          name: 'dns.question.registered_domain',
          value: dnsName,
          type: 'keyword',
          aggregatable: true
        }
      }, (0, _empty_value.defaultToEmptyTag)(dnsName));
    } else {
      return (0, _empty_value.getEmptyTagValue)();
    }
  }
}, {
  align: 'right',
  field: `node.${_search_strategy.NetworkDnsFields.queryCount}`,
  name: i18n.TOTAL_QUERIES,
  sortable: true,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: queryCount => {
    if (queryCount != null) {
      return (0, _numeral.default)(queryCount).format('0');
    } else {
      return (0, _empty_value.getEmptyTagValue)();
    }
  }
}, {
  align: 'right',
  field: `node.${_search_strategy.NetworkDnsFields.uniqueDomains}`,
  name: i18n.UNIQUE_DOMAINS,
  sortable: true,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: uniqueDomains => {
    if (uniqueDomains != null) {
      return (0, _numeral.default)(uniqueDomains).format('0');
    } else {
      return (0, _empty_value.getEmptyTagValue)();
    }
  }
}, {
  align: 'right',
  field: `node.${_search_strategy.NetworkDnsFields.dnsBytesIn}`,
  name: i18n.DNS_BYTES_IN,
  sortable: true,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: dnsBytesIn => {
    if (dnsBytesIn != null) {
      return /*#__PURE__*/_react.default.createElement(_formatted_bytes.PreferenceFormattedBytes, {
        value: dnsBytesIn
      });
    } else {
      return (0, _empty_value.getEmptyTagValue)();
    }
  }
}, {
  align: 'right',
  field: `node.${_search_strategy.NetworkDnsFields.dnsBytesOut}`,
  name: i18n.DNS_BYTES_OUT,
  sortable: true,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: dnsBytesOut => {
    if (dnsBytesOut != null) {
      return /*#__PURE__*/_react.default.createElement(_formatted_bytes.PreferenceFormattedBytes, {
        value: dnsBytesOut
      });
    } else {
      return (0, _empty_value.getEmptyTagValue)();
    }
  }
}];
exports.getNetworkDnsColumns = getNetworkDnsColumns;