"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initialHostsState = exports.hostsReducer = void 0;
var _typescriptFsaReducers = require("typescript-fsa-reducers");
var _search_strategy = require("../../../../common/search_strategy");
var _constants = require("../../../common/store/constants");
var _actions = require("./actions");
var _helpers = require("./helpers");
var _model = require("./model");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialHostsState = {
  page: {
    queries: {
      [_model.HostsTableType.authentications]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT
      },
      [_model.HostsTableType.hosts]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT,
        direction: _search_strategy.Direction.desc,
        sortField: _search_strategy.HostsFields.lastSeen
      },
      [_model.HostsTableType.events]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT
      },
      [_model.HostsTableType.uncommonProcesses]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT
      },
      [_model.HostsTableType.anomalies]: {
        jobIdSelection: [],
        intervalSelection: 'auto'
      },
      [_model.HostsTableType.risk]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT,
        sort: {
          field: _search_strategy.RiskScoreFields.hostRiskScore,
          direction: _search_strategy.Direction.desc
        },
        severitySelection: []
      },
      [_model.HostsTableType.sessions]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT
      }
    }
  },
  details: {
    queries: {
      [_model.HostsTableType.authentications]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT
      },
      [_model.HostsTableType.hosts]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        direction: _search_strategy.Direction.desc,
        limit: _constants.DEFAULT_TABLE_LIMIT,
        sortField: _search_strategy.HostsFields.lastSeen
      },
      [_model.HostsTableType.events]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT
      },
      [_model.HostsTableType.uncommonProcesses]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT
      },
      [_model.HostsTableType.anomalies]: {
        jobIdSelection: [],
        intervalSelection: 'auto'
      },
      [_model.HostsTableType.risk]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT,
        sort: {
          field: _search_strategy.RiskScoreFields.hostRiskScore,
          direction: _search_strategy.Direction.desc
        },
        severitySelection: []
      },
      [_model.HostsTableType.sessions]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT
      }
    }
  }
};
exports.initialHostsState = initialHostsState;
const hostsReducer = (0, _typescriptFsaReducers.reducerWithInitialState)(initialHostsState).case(_actions.setHostTablesActivePageToZero, state => ({
  ...state,
  page: {
    ...state.page,
    queries: (0, _helpers.setHostPageQueriesActivePageToZero)(state)
  },
  details: {
    ...state.details,
    queries: (0, _helpers.setHostDetailsQueriesActivePageToZero)(state)
  }
})).case(_actions.setHostDetailsTablesActivePageToZero, state => ({
  ...state,
  details: {
    ...state.details,
    queries: (0, _helpers.setHostDetailsQueriesActivePageToZero)(state)
  }
})).case(_actions.updateTableActivePage, (state, {
  activePage,
  hostsType,
  tableType
}) => ({
  ...state,
  [hostsType]: {
    ...state[hostsType],
    queries: {
      ...state[hostsType].queries,
      [tableType]: {
        ...state[hostsType].queries[tableType],
        activePage
      }
    }
  }
})).case(_actions.updateTableLimit, (state, {
  limit,
  hostsType,
  tableType
}) => ({
  ...state,
  [hostsType]: {
    ...state[hostsType],
    queries: {
      ...state[hostsType].queries,
      [tableType]: {
        ...state[hostsType].queries[tableType],
        limit
      }
    }
  }
})).case(_actions.updateHostsSort, (state, {
  sort,
  hostsType
}) => ({
  ...state,
  [hostsType]: {
    ...state[hostsType],
    queries: {
      ...state[hostsType].queries,
      [_model.HostsTableType.hosts]: {
        ...state[hostsType].queries[_model.HostsTableType.hosts],
        direction: sort.direction,
        sortField: sort.field,
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
      }
    }
  }
})).case(_actions.updateHostRiskScoreSort, (state, {
  sort,
  hostsType
}) => ({
  ...state,
  [hostsType]: {
    ...state[hostsType],
    queries: {
      ...state[hostsType].queries,
      [_model.HostsTableType.risk]: {
        ...state[hostsType].queries[_model.HostsTableType.risk],
        sort
      }
    }
  }
})).case(_actions.updateHostRiskScoreSeverityFilter, (state, {
  severitySelection,
  hostsType
}) => ({
  ...state,
  [hostsType]: {
    ...state[hostsType],
    queries: {
      ...state[hostsType].queries,
      [_model.HostsTableType.risk]: {
        ...state[hostsType].queries[_model.HostsTableType.risk],
        severitySelection,
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
      }
    }
  }
})).case(_actions.updateHostsAnomaliesJobIdFilter, (state, {
  jobIds,
  hostsType
}) => ({
  ...state,
  [hostsType]: {
    ...state[hostsType],
    queries: {
      ...state[hostsType].queries,
      [_model.HostsTableType.anomalies]: {
        ...state[hostsType].queries[_model.HostsTableType.anomalies],
        jobIdSelection: jobIds
      }
    }
  }
})).case(_actions.updateHostsAnomaliesInterval, (state, {
  interval,
  hostsType
}) => ({
  ...state,
  [hostsType]: {
    ...state[hostsType],
    queries: {
      ...state[hostsType].queries,
      [_model.HostsTableType.anomalies]: {
        ...state[hostsType].queries[_model.HostsTableType.anomalies],
        intervalSelection: interval
      }
    }
  }
})).build();
exports.hostsReducer = hostsReducer;