"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SessionsTabBody = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _types = require("../../../../app/types");
var _sessions_viewer = require("../../../../common/components/sessions_viewer");
var _utils = require("../../../../common/components/visualization_actions/utils");
var _use_license = require("../../../../common/hooks/use_license");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SessionsTabBody = /*#__PURE__*/_react.default.memo(alertsProps => {
  const {
    pageFilters,
    filterQuery,
    ...rest
  } = alertsProps;
  const hostPageFilters = (0, _react.useMemo)(() => {
    const hostNameExistsFilter = (0, _utils.fieldNameExistsFilter)(_types.SecurityPageName.hosts);
    return pageFilters != null ? [...hostNameExistsFilter, ...pageFilters] : hostNameExistsFilter;
  }, [pageFilters]);
  const isEnterprisePlus = (0, _use_license.useLicense)().isEnterprise();
  return isEnterprisePlus ? /*#__PURE__*/_react.default.createElement(_sessions_viewer.SessionsView, (0, _extends2.default)({
    entityType: "sessions",
    tableId: _securitysolutionDataTable.TableId.hostsPageSessions
  }, rest, {
    pageFilters: hostPageFilters,
    filterQuery: filterQuery
  })) : null;
});
exports.SessionsTabBody = SessionsTabBody;
SessionsTabBody.displayName = 'SessionsTabBody';